<?php

/*
 * This file is part of Referral Spam Detect.
 *
 * (c) Mark Beech <m@rkbee.ch>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace Jaybizzle\ReferralSpamDetect\Fixtures;

class SpamReferrers extends AbstractProvider
{
    /**
     * Array of domains to match agaist the referring URL.
     *
     * @var array
     */
    protected $data = array(
        '000free.us',
        '007angels.com',
        '00author.com',
        '00go.com',
        '00it.com',
        '00webcams.com',
        '01apple.com',
        '03e.info',
        '03p.info',
        '08800.top',
        '0912701309f8ce.com',
        '0c47f8422d3f.com',
        '0daymusic.org',
        '0lovespells0.blogspot.com',
        '0n-line.tv',
        '1-99seo.com',
        '1-free-share-buttons.com',
        '1000n1.ru',
        '1001watch.com.ua',
        '100dollars-seo.com',
        '100searchengines.com',
        '101billion.com',
        '101flag.ru',
        '101lesbian.xyz',
        '101raccoon.ru',
        '108shot.com',
        '10bet.com',
        '11235813.webzdarma.cz',
        '11pikachu.ru',
        '123any.com',
        '123cha.com',
        '123kuma.com',
        '123locker.com',
        '12bet.com',
        '12masterov.com',
        '12u.info',
        '1314dh.com',
        '13tabs.com',
        '14b.info',
        '1688.com',
        '178evakuator178.ru',
        '1adult.com',
        '1bet.com',
        '1flag.co.za',
        '1hwy.com',
        '1j7740kd.website',
        '1kdailyprofit.me',
        '1kinobig.ru',
        '1millionusd.xyz',
        '1pamm.ru',
        '1qingdao.com',
        '1stat.ru',
        '1webmaster.ml',
        '2000k.ru',
        '2015god.org',
        '2020iscoming.info',
        '202ch.com',
        '20pascals.nl',
        '214jaluwobapef.cf',
        '21h2o.com',
        '2345.com',
        '23kw.ru',
        '24-ak.ru',
        '24videos.tv',
        '24x7-server-support.site',
        '256bit.by',
        '2728fb936f0.com',
        '273-fz.ru',
        '28n2gl3wfyb0.ru',
        '2ads.co.uk',
        '2drittel.de',
        '2girls1cup-free.com',
        '2itech.ru',
        '2kata.ru',
        '2nt.ru',
        '2pxg8bcf.top',
        '2rich4bitches.com',
        '2x2fan.ru',
        '3-letter-domains.net',
        '300richmond.co.nz',
        '34.gs',
        '3dracergames.com',
        '3rbseyes.com',
        '3th.co.in',
        '3w24.com',
        '3weekdiet.com',
        '3xforum.ro',
        '40cg.com',
        '45en.ru',
        '4inn.ru',
        '4istoshop.com',
        '4k-player.pl',
        '4kplayer.pl',
        '4pp13.com',
        '4rent.ru',
        '4replicawatch.net',
        '4ur.click',
        '4ureyesonly.com',
        '4webmasters.com',
        '4webmasters.org',
        '5-steps-to-start-business.com',
        '5000-cotydzien.com',
        '51.la',
        '51unlim.ru',
        '55wmz.ru',
        '57883.net',
        '5elementov.ru',
        '5forex.ru',
        '5i2.net',
        '5kstore.com',
        '5tey7463.weebly.com',
        '5u.com',
        '5ws.dating-app.ru',
        '6128786.com',
        '66cpwgln.space',
        '6hopping.com',
        '72-news.com',
        '76brighton.co.uk',
        '777-club.ru',
        '7a2rnuey1tw9ar.ru',
        '7fon.ru',
        '7makemoneyonline.com',
        '7minuteworkout.com',
        '7search.com',
        '7wind.ru',
        '7xc4n.com',
        '7yue.org',
        '7zap.com',
        '83net.jp',
        '8558l.jobs.net',
        '883zy.com',
        '888.com',
        '8gold.com',
        '8jn.dating-app.ru',
        '8kisses.eu',
        '8lufu.com',
        '8si.ru',
        '8xv8.com',
        '91abcw.com',
        '98oi.ru',
        '991mostfm.co.id',
        '999webdesign.com',
        '9icmzvn6.website',
        '9med.net',
        'a.frcls.fr',
        'a.pr-cy.ru',
        'a14download.com',
        'a1security.com.ua',
        'a96527gi.beget.tech',
        'aa08daf7e13b6345e09e92f771507fa5f4.com',
        'aa14ab57a3339c4064bd9ae6fad7495b5f.com',
        'aa625d84f1587749c1ab011d6f269f7d64.com',
        'aa81bf391151884adfa3dd677e41f94be1.com',
        'aa8780bb28a1de4eb5bff33c28a218a930.com',
        'aa8b68101d388c446389283820863176e7.com',
        'aa9bd78f328a6a41279d0fad0a88df1901.com',
        'aa9d046aab36af4ff182f097f840430d51.com',
        'aaa38852e886ac4af1a3cff9b47cab6272.com',
        'aab94f698f36684c5a852a2ef272e031bb.com',
        'aac500b7a15b2646968f6bd8c6305869d7.com',
        'aac52006ec82a24e08b665f4db2b5013f7.com',
        'aad1f4acb0a373420d9b0c4202d38d94fa.com',
        'aadroid.net',
        'aanapa.ru',
        'aarbur.com',
        'aaronabel.com',
        'aasoldes.fr',
        'abbanreddy.com',
        'abcdefh.xyz',
        'abcdeg.xyz',
        'abcguru.xyz',
        'abclauncher.com',
        'abctoppictures.net',
        'abiente.ru',
        'above.com',
        'abovetherivernc.com',
        'absolute-s.ru',
        'absolutelyanalog.com',
        'absugars.com',
        'abtasty.com',
        'abusora.com',
        'abwa.tk',
        'academia-nsk.org',
        'academiacsmendoza.org',
        'acads.net',
        'acc.eu.org',
        'accessoires-mode.in',
        'acgs.tk',
        'acheterviagrafr24.com',
        'acortarurl.es',
        'actices.com',
        'actionnooz.com',
        'activecampaign.dreamhosters.com',
        'activepr.ru',
        'actulite.com',
        'acunetix-referrer.com',
        'ad-words.ru',
        'adamoads.com',
        'adanih.com',
        'adbetclickin.pink',
        'adcash.com',
        'adclickservice.com',
        'adclickthru.net',
        'adconscious.com',
        'add-add.men',
        'addbin.men',
        'addblueoff.com.ua',
        'addray.pro',
        'addtoadd.men',
        'adelly.bg',
        'adexprts.com',
        'adf.ly',
        'adhome.biz',
        'adidas.frwebs.fr',
        'adimmix.com',
        'adinterax.com',
        'adktrailmap.com',
        'adloads.com',
        'adloads.net',
        'adman.gr',
        'adman.se',
        'admanaerofoil.com',
        'admatic.com.tr',
        'admeasures.com',
        'adminshop.com',
        'admitad.com',
        'adnotbad.com',
        'adobereader-free.ru',
        'adpremium.org',
        'adprotect.net',
        'adrenalin-stk.ru',
        'ads-cool.pro',
        'ads-seo.men',
        'ads.gold',
        'ads.tremorhub.com',
        'adserver-e7.com',
        'adservme.com',
        'adsfresh.men',
        'adsland.men',
        'adsloads.com',
        'adsref.men',
        'adssafeprotected.com',
        'adtech.de',
        'adtech.fr',
        'adtech.us',
        'adtiger.tk',
        'adtology.com',
        'adult-shop.com.ua',
        'adult3dgames.com',
        'adultactioncam.com',
        'adultfriendfinder.com',
        'adultfullhd.com',
        'adultgalls.com',
        'adultmeetonline.info',
        'adultnet.in',
        'adultwebhosting.info',
        'advancedcleaner.com',
        'advancedsoftwaresupport.com',
        'adventureparkcostarica.com',
        'adverster.com',
        'advertex.info',
        'advertisingtag.net',
        'adviceforum.info',
        'advocatemsk.ru',
        'advokat-grodno.by',
        'advokateg.ru',
        'advokateg.xyz',
        'adzerg.com',
        'adzpower.com',
        'aero2.ru',
        'aerogo.com',
        'affiliate-fr.com',
        'affordablewebsitesandmobileapps.com',
        'affrh2015.com',
        'afftrack001.com',
        'afmuseum.com',
        'afora.ru',
        'afslankpillen2017nl.eu',
        'agadelha.com.br',
        'agahinameh.com',
        'agapovdg.ru',
        'agardomains.com',
        'agecheckadult.com',
        'aghanyna.com',
        'agreda.pluto.ro',
        'agroeconom.kz',
        'agysya.ru',
        'ahrefs.com',
        'ahrntal.verymes.xyz',
        'aibolita.com',
        'aihelen.net',
        'aimayangzhi.com',
        'air-edem.ru',
        'airlandsea.info',
        'airmaxshoes-2016.com',
        'akama.com',
        'akita.kz',
        'aksonural.ru',
        'aktivator-windows10.blogspot.com',
        'aktobe.xkaz.org',
        'akuhni.by',
        'akusherok.ru',
        'akvamaster.dp.ua',
        'alarmobninsk.ru',
        'albamargroup.com',
        'alborzan.com',
        'albumsuper.info',
        'alekseevec.ru',
        'alert-fdm.xyz',
        'alert-fjg.xyz',
        'alert-hgd.xyz',
        'alert-jdh.xyz',
        'alert.scansafe.net',
        'alessandraleone.com',
        'alf-img.com',
        'alfa-img.com',
        'alfa-medosmotr.ru',
        'alfa9.com',
        'alfabot.xyz',
        'alfapro.ru',
        'algerianembassy.co.in',
        'alibestsale.com',
        'alice.it',
        'alienwheel.es',
        'alienwheels.de',
        'aliexpress.com',
        'aliexpresscashback.club',
        'alif-ba-ta.com',
        'alive-ua.com',
        'alkoravto.ru',
        'all-number.com',
        'all-streaming-media.com',
        'all4invest.info',
        'all4invest.ru',
        'all4wap.ru',
        'allbizne.co.ua',
        'allblogroll.com',
        'allboard.xobor.de',
        'allcredits.su',
        'alldezservice.kz',
        'alldownload.pw',
        'alldubai.biz',
        'allesohnegirls.net',
        'allforminecraft.ru',
        'allknow.info',
        'allkrim.com',
        'allmarketsnewdayli.gdn',
        'allnews.md',
        'allnews24.in',
        'alloysteel.ru',
        'allpdfmags.net',
        'allsilver925.co.il',
        'allstatesugarbowl.org',
        'alltheviews.com',
        'allwidewallpapers.com',
        'allwomen.info',
        'aloofly.com',
        'alot.com',
        'alphacarolinas.com',
        'alphaforum.ru',
        'alphahoverboards.com',
        'alpharma.net',
        'alphavisions.net',
        'alpinism.ru',
        'alt-servis.ru',
        'alta-realestate.com',
        'altamayoztourism.com',
        'alveris.ru',
        'alvtank.se',
        'alyeskaresort.com',
        'am-se.com',
        'am15.net',
        'amanda-porn.ga',
        'amateurgalls.com',
        'amateurlivechat.org',
        'amateurmatch.com',
        'amazingninja.com',
        'amazingpic.net',
        'amazon-adsystem.com',
        'amazon-seo-service.com',
        'ameblo.jp',
        'amehdaily.com',
        'amigobulls.com',
        'amoi.tn',
        'amospalla.es',
        'ample-awards-today.us',
        'ampower.me',
        'amt-k.ru',
        'amung.us',
        'amyfoxfitness.com',
        'an-donut.com',
        'anabolics.shop',
        'anaksma.info',
        'anal-acrobats.com',
        'anal-acrobats.hol.es',
        'analytics-ads.xyz',
        'anapa-inns.ru',
        'andpolice.com',
        'android-style.com',
        'android-systems.ru',
        'android-vsem.org',
        'android4fun.org',
        'androids-store.com',
        'angigreene.com',
        'angkortours.vn',
        'angry-fermi-7633.arukascloud.io',
        'animal-drawings.com',
        'animal36.com',
        'animali.deagostinipassion.it',
        'animalia-life.club',
        'animalrank.com',
        'animaltoplist.com',
        'anime.dougasouko.com',
        'animebox.com.ua',
        'animenime.ru',
        'anjalika.co.in',
        'anlimebel.kiev.ua',
        'anmysite.com',
        'anniemation.com',
        'anonymizeme.pro',
        'anonymous-redirect.com',
        'anti-virus-removal.info',
        'anticrawler.org',
        'antons-transporte.de',
        'aosexkontakte.net',
        'aosheng-tech.com',
        'ap.senai.br',
        'apartamentwroclaw.eu',
        'apartment.ru',
        'apartmentbay.ru',
        'apartmentratings.com',
        'apccargo.com',
        'apelsinnik.website',
        'apessay.com',
        'api.stathat.com',
        'apiadanaknet-a.akamaihd.net',
        'apiallgeniusinfo-a.akamaihd.net',
        'apiappenableinfo-a.akamaihd.net',
        'apibatbrowsecom-a.akamaihd.net',
        'apibetweenlinesn-a.akamaihd.net',
        'apibrowsesmartne-a.akamaihd.net',
        'apidiamondatanet-a.akamaihd.net',
        'apidigidocketnet-a.akamaihd.net',
        'apifasterlightin-a.akamaihd.net',
        'apiholdingmypage-a.akamaihd.net',
        'apiitsthirteende-a.akamaihd.net',
        'apilinkswiftco-a.akamaihd.net',
        'apiluckyleapnet-a.akamaihd.net',
        'apimegabrowsebiz-a.akamaihd.net',
        'apimossnetinfo-a.akamaihd.net',
        'apimountainbikei-a.akamaihd.net',
        'apioasisspacenet-a.akamaihd.net',
        'apioutoboxnet-a.akamaihd.net',
        'apiportalmorecom-a.akamaihd.net',
        'apiqualitinknet-a.akamaihd.net',
        'apisecretsaucebi-a.akamaihd.net',
        'apishops.ru',
        'apispringsmartne-a.akamaihd.net',
        'apiwebwebgetcom-a.akamaihd.net',
        'apiwoodensealcom-a.akamaihd.net',
        'app-ready.xyz',
        'app5.letmacworkfaster.world',
        'apparel-offer.com',
        'appartement-stumm.at',
        'appearance-cool.com',
        'apper.de',
        'appfastplay.com',
        'appfixing.space',
        'appiq.mobi',
        'apple.com-cleaner.systems',
        'apple.com-webbrowsing-security.review',
        'apple.com-webbrowsing-security.science',
        'appleid-verification.com',
        'applicationg29.com',
        'applyneedy.xyz',
        'approved.su',
        'approvedlocal.co.za',
        'apps-analytics.net',
        'appsaurus.com',
        'appsecurityr.com',
        'apptester.tk',
        'aproposde.com',
        'apxeo.info',
        'aquarium-pro.ru',
        'arabgirls.adultgalls.com',
        'arabsexxxtube.com',
        'arabseyes.com',
        'aramaicmedia.org',
        'arate.ru',
        'arcadepages.com',
        'arcadeplayhouse.com',
        'architecturebest.com',
        'arclk.net',
        'arcteryxsale.online',
        'arcteryxstore.online',
        'ardimobileinfo.ml',
        'arenanews.com.ua',
        'arenda-avtoprokat-krasnodar.ru',
        'arenda-yeisk.ru',
        'arendakvartir.kz',
        'arendas.net',
        'arendatora.ru',
        'arendovalka.xyz',
        'arewater.com',
        'arius.tech',
        'arkartex.ru',
        'arkkivoltti.net',
        'arpelsreplica.xyz',
        'arquapetrarca.info',
        'arraty.altervista.org',
        'artavenuegardenstudios.com',
        'artdeko.info',
        'artdestshop.eu',
        'artefakct.com',
        'artel116.ru',
        'articlesdirectoryme.info',
        'artparquet.ru',
        'artpicso.com',
        'aruplighting.com',
        'arvut.org',
        'as5000.com',
        'asacopaco.tk',
        'ascat.porn',
        'asdfg.pro',
        'asdfz.pro',
        'asia-forum.ru',
        'asiengirls.net',
        'asmxsatadriverin.aircus.com',
        'asociatia-tipografilor-transilvania.ro',
        'asophoto.com',
        'asrv-a.akamaihd.net',
        'asrv-a.akamoihd.net',
        'asrvrep-a.akamaihd.net',
        'asrvvv-a.akamaihd.net',
        'asscenihotosidea.blogspot.co.za',
        'asscenihotosidea.blogspot.com',
        'asseenontv.ru',
        'asseenontvonline.ru',
        'astana.xxxkaz.org',
        'astrochicks.com',
        'atelielembrancaqueencanta.com.br',
        'atlant-auto.info',
        'atlasvkusov.ru',
        'atleticpharm.org',
        'atley.eu.pn',
        'atmagroup.ru',
        'atmovs.com',
        'atofilms.com',
        'atout-energie-69.com',
        'atovh.local-finders.com',
        'audiobangout.com',
        'audiofree.ru',
        'ausergrubhof.info',
        'ausmepa.org.au',
        'auspolice.com',
        'aussie-prizes.com',
        'australia-opening-times.com',
        'auto-moto-elektronika.cz',
        'auto-zapchasti.org',
        'auto.rusvile.lt',
        'auto4style.ru',
        'autoblogger24.info',
        'autobrennero.it',
        'autobudpostach.club',
        'autochoixspinelli.com',
        'autodo.info',
        'autogrep.ru',
        'autoloans.com',
        'autolombard-krasnodar.ru',
        'automatic-seo.com',
        'autonew.biz',
        'autoplate.info',
        'autorn.ru',
        'autoseo-traffic.com',
        'autotop.com.ua',
        'autotrends.today',
        'autoua.top',
        'autovideobroadcast.com',
        'autowebmarket.com.ua',
        'availit.weebly.com',
        'avek.ru',
        'aversis.net',
        'aviapanda.ru',
        'aviav.co',
        'aviav.eu',
        'aviav.org',
        'aviav.ru',
        'aviav.ru.com',
        'avirasecureserver.com',
        'avitocars.ru',
        'aviva-limoux.com',
        'avkzarabotok.com',
        'avkzarabotok.info',
        'avon-novosib.ru',
        'avon-severozapad.ru',
        'avon-ukraine.com',
        'avramstroy.ru',
        'avtoarenda.by',
        'avtochehli.by',
        'avtocredit-legko.ru',
        'avtointeres.ru',
        'avtolombard-krasnodar.com',
        'avtolombard-krasnodar.ru',
        'avtovolop.ru',
        'away.vk.com',
        'awaybird.ru',
        'awency.com',
        'axbocz.net',
        'ayakino.net',
        'ayanaspa.com',
        'ayeartoforget.com',
        'ayerbo.xhost.ro',
        'azadnegar.com',
        'azartclub.org',
        'azartmix.com',
        'azartniy-bonus.com',
        'azazaporn.com',
        'azazu.ru',
        'azbaseimages.net',
        'azbuka-mo.ru',
        'azbukadiets.ru',
        'azbukafree.com',
        'azlex.uz',
        'azte.ch',
        'b-styles.xyz',
        'b00kmarks.com',
        'b2b-lounge.com',
        'babespcs.com',
        'babieca.com',
        'bablonow.ru',
        'babs.com.ua',
        'babyfactory.fr',
        'babyguns.ru',
        'back.dog',
        'backgroundpictures.net',
        'backlink4u.net',
        'backlinkwatch.com',
        'backuperwebcam.weebly.com',
        'bad-stars.net',
        'baditri.com',
        'baersaratov.ru',
        'bag77.ru',
        'bagcionderlab.com',
        'bagsonsale.online',
        'baixar-musicas-gratis.com',
        'baksman.com',
        'bala.getenjoyment.net',
        'baladur.ru',
        'balans.shahterworld.org',
        'balitouroffice.com',
        'balkanfarma.org',
        'balkanfarma.ru',
        'balla-boo.se',
        'balois.worldbreak.com',
        'balook.com',
        'baltgem.com',
        'bambi.ck.ua',
        'bamo.xsl.pt',
        'banan.tv',
        'bang-hotties.com',
        'bangla-chat-uk-paralud.ga',
        'bank.uz',
        'bankcrediti.ru',
        'banki76.ru',
        'bankiem.pl',
        'bankmib.ru',
        'bankofthewext.com',
        'bannerads.de',
        'bannerbank.ru',
        'bannerconnect.net',
        'bannerpower.com',
        'bannerspace.com',
        'bannerswap.com',
        'bannertesting.com',
        'baoxaydung.com.vn',
        'barbourjackets.online',
        'bard-real.com.ua',
        'barnfurnituremart.com',
        'basedecor.ru',
        'bashtime.ru',
        'basisches-wasser.net',
        'batanga.net',
        'battle.net',
        'battlecarnival.su',
        'battleforupdating.site',
        'bausparen.bz.it',
        'bayareaaeroclub.org',
        'bazaronline24.ru',
        'bbsoldes.fr',
        'bbtec.net',
        'bcmp.org',
        'bdsmgalls.net',
        'beachdriveblog.com',
        'beachpics.com',
        'beachtoday.ru',
        'bear.gotcher.us',
        'beatifullandscape.co',
        'beauby.ru',
        'beauty-b0x.pl',
        'beauty-bracelet.com',
        'beauty-clinic.ru',
        'beauty-things.com',
        'beclean-nn.ru',
        'becuo.com',
        'bedandbreakfast.com',
        'bedcapdealers.com',
        'begalka.xyz',
        'beget.tech',
        'belinka.com.ua',
        'belinvestdom.by',
        'belstaffstore.online',
        'benchmarkcommunications.co.uk',
        'bensbargains.net',
        'berdasovivan.ru',
        'beremenyashka.com',
        'berlininsl.com',
        'berrymall.ru',
        'best-businessman.ru',
        'best-coupon-offer.com',
        'best-deals-products.com',
        'best-games.today',
        'best-seo-offer.com',
        'best-seo-software.xyz',
        'best-seo-solution.com',
        'best-way.men',
        'bestadbid.com',
        'bestbrainprod.win',
        'bestbuy.ca',
        'bestcalovebracelet.cn',
        'bestchoice.cf',
        'bestcoin.cc',
        'bestcurs.org',
        'bestdooz.com',
        'bestdraws.com',
        'bestempresas.es',
        'besthoro.ru',
        'bestimagecoollibrary.com',
        'bestkfiledxd.cf',
        'bestmarriages.com',
        'bestmobilityscooterstoday.com',
        'bestofferswalkmydogouteveryday.gq',
        'bestofpicture.com',
        'bestofupload.info',
        'bestplacetobuyeriacta.jw.lt',
        'bestpriceninja.com',
        'bestprofits-there.com',
        'bestserials.com',
        'bestssaker.com',
        'besttorrentknifta.weebly.com',
        'bestwaystogetpaid.us',
        'bestwebsiteawards.com',
        'bestwebsitesawards.com',
        'bestwrinklecreamnow.com',
        'bet-prognoz.com',
        'bet365.com',
        'beta.hotkeys.com',
        'betonka.pro',
        'betterhdporn.com',
        'betteroffers.review',
        'betterscooter.com',
        'betune.onlinewebshop.net',
        'betwinservice.com',
        'beyan.host.sk',
        'bezcmexa.ru',
        'bezlimitko.xyz',
        'bezsporno.ru',
        'beztuberkuleza.ru',
        'bfz.biz',
        'bharatdefencekavach.com',
        'bibys.com',
        'bidbuy.co.kr',
        'bidr.trellian.com',
        'bif-ru.info',
        'big-boards.info',
        'big-cash.net',
        'bigames.online',
        'bigcareer.info',
        'bigcities.org',
        'biglistofwebsites.com',
        'bigpenisguide.com',
        'bigpictures.club',
        'biketank.ga',
        'bikini-image.com',
        'bildsuche.ru',
        'billiard-classic.com.ua',
        'bimatoprost-careprost.com',
        'bimatoprost-careprost.com.ua',
        'binaryoptionscops.info',
        'bingo8888.com',
        'binomo.com',
        'binomo.kz',
        'bio-japan.net',
        'bio-market.kz',
        'bio-optomarket.ru',
        'bio.trade-jp.net',
        'bioca.org',
        'biographiya.com',
        'bioscorp.ru',
        'bird1.ru',
        'birzha-truda.eu',
        'bitcoinpile.com',
        'bitcoinremote.com',
        'bitcoins-live.ru',
        'biteg.xyz',
        'bitnote.co',
        'bitporno.sx',
        'bizcheapjerseyswholesalechina.com',
        'bizfly.info',
        'bizlist.com.de',
        'biznesluxe.ru',
        'biznesrealnost.ru',
        'biznesschat.net',
        'bizru.info',
        'bjanshee.ru',
        'bjetjt.com',
        'bjgugu.net.ua',
        'bjorkbacken.nu',
        'bkgr.se',
        'bkns.vn',
        'blackcurranthumidifiers.site',
        'blackhatworth.com',
        'blackle.com',
        'blackplanet.com',
        'blacktwhite.com',
        'blackwitchcraft.ru',
        'blagovest-med.ru',
        'blavia.00author.com',
        'blobar.org',
        'blockworld.ru',
        'blog-hits.com',
        'blog.axant.it',
        'blog.f00kclan.de',
        'blog.koorg.ru',
        'blog.koreadaily.com',
        'blog.remote-computer.de',
        'blog.yam.com',
        'bloggedporn.com',
        'bloggen.be',
        'bloggerads.net',
        'bloggers.nl',
        'blogig.org',
        'blogos.kz',
        'blogporn.in',
        'blogqpot.com',
        'blogrankers.com',
        'blogs.rediff.com',
        'bloke.com',
        'blpmovies.com',
        'blue-square.biz',
        'bluejays-jerseys.us',
        'bluerobot.info',
        'bluesalt.co',
        'bluesman.nu',
        'bmsco.co',
        'bmw-ark.ru',
        'bmw.afora.ru',
        'bmwhighperformers.com',
        'bnt-team.com',
        'board.f00d.de',
        'boazpower.com',
        'bobba.dzaba.com',
        'bobinoz.com',
        'boc.kz',
        'bochemit.com.ua',
        'bocoarchives.org',
        'bodybuilding-shop.biz',
        'bolegapakistan.com',
        'boleznikogi.com',
        'bolezniorganov.ru',
        'bolitgorlo.net',
        'boltalko.xyz',
        'bombla.org',
        'bonanza-fortune.men',
        'bongacams.com',
        'bongiornos.info',
        'bonkers.name',
        'bonky.biz',
        'bonux.nextview.ru',
        'bonvillan.com',
        'bonzbuddy.com',
        'bonzibuddi.com',
        'bonzybuddy.com',
        'boobsimge.com',
        'bookhome.info',
        'bookmaker-bet.com',
        'bookmark4you.com',
        'bookmark4you.com.biz',
        'boole.onlinewebshop.net',
        'boostmyppc.com',
        'bosefux.esy.es',
        'bosman.pluto.ro',
        'bouda.kvalitne.cz',
        'bpro1.top',
        'brainboosting.club',
        'brainboostingsupplements.org',
        'braindaily.xyz',
        'brains2.biz',
        'brainsandeggs.blogspot.com',
        'braintobe.win',
        'brainxs.us',
        'brainzpod.win',
        'braip.com.br',
        'brakehawk.com',
        'brandbucket.com',
        'brandedleadgeneration.com',
        'brandehk.dk',
        'brandov.ru',
        'brateg.xyz',
        'bravegirlsclub.com',
        'break-the-chains.com',
        'breastaugmentation.co.za',
        'breget74.ru',
        'brendbutik.ru',
        'brewdom.ru',
        'brg8.com',
        'brillianty.info',
        'brimstonehillfortress.org',
        'briomotor.co',
        'bristolhostel.com',
        'bristolhotel.com',
        'bristolhotel.com.ua',
        'brk-rti.ru',
        'brokergid.ru',
        'bronzeaid-a.akamaihd.net',
        'brothers-smaller.ru',
        'browsepulse-a.akamaihd.net',
        'browserprotecter.com',
        'brus-vsem.ru',
        'brus.city',
        'bryansk.zrus.org',
        'bscodecs.com',
        'btc4u.ru',
        'btnativenav.com',
        'btvn.ru',
        'buchananshardware.com',
        'buckspar.gq',
        'budilneg.xyz',
        'budpost.com.ua',
        'buehne-fuer-menschenrechte.de',
        'bugof.gq',
        'buigas.00it.com',
        'builtwith.com',
        'buketeg.xyz',
        'bukleteg.xyz',
        'bum.com.ru',
        'bumascloset.com',
        'bumble.cheapwebsitehoster.com',
        'bumskontakte.org',
        'buntube.net',
        'bupropion-sr-150-mg.us',
        'buqayy0.livejournal.com',
        'buqyxa.rincian.info',
        'burger-imperia.com',
        'burkesales.com',
        'burn-fat.ga',
        'buron.pw',
        'bus-offer.com',
        'businescoop.men',
        'businesn.men',
        'business-made-fun.com',
        'business-suggested.tk',
        'businesxxl.com',
        'butstrap.space',
        'buttons-for-website.com',
        'buttons-for-your-website.com',
        'buy-cheap-online.info',
        'buy-cheap-pills-order-online.com',
        'buy-forum.ru',
        'buy-loft.ru',
        'buy-meds24.com',
        'buyantiviralwp.com',
        'buybest1.biz',
        'buyclomidonlaine.com',
        'buydissertation.net',
        'buyessay3.blogspot.ru',
        'buyessaynow.biz',
        'buyessayonline19.blogspot.ru',
        'buyfriend.ru',
        'buyhoverboard.com',
        'buyk.host.sk',
        'buynorxx.com',
        'buypanicdisorderpill.com',
        'buyparajumpers.online',
        'buypillsorderonline.com',
        'buypuppies.ca',
        'buyscabiescream.com',
        'buytizanidineonline.blogspot.com',
        'buytizanidineonlinenoprescription.blogspot.com',
        'buyviagraa.blogspot.com',
        'buzz-porno.info',
        'buzzonclick.com',
        'buzzsumo.com',
        'buzzurl.jp',
        'buzzzg.men',
        'bvlgaribracelet.xyz',
        'bvlgariring.xyz',
        'bvlgariwallet.xyz',
        'bwlx.prepedu.cn',
        'bycontext.com',
        'byme.se',
        'bytimedance.ru',
        'bzero1jewelry.net',
        'c-english.ru',
        'c-gainsbourg.com',
        'c1.onedmp.com',
        'cablecar.us',
        'cacheimages.com',
        'cactussoft.biz',
        'cakemediahq.com.au',
        'cakesplus.com.au',
        'calc-for-credit.ru',
        'calcularpagerank.com',
        'californianews.cf',
        'call-of-duty.info',
        'callawaygolfoutlet.online',
        'callawaygolfstore.online',
        'callejondelpozo.es',
        'callmd5map.com',
        'calstaterealty.us',
        'calvet.altervista.org',
        'cam-kontakte.org',
        'camdenmemorials.com',
        'camdolls.com',
        'camel-beach.com',
        'camsex.xxx-cam.webcam',
        'canacopegdl.com',
        'cand.jp',
        'candcstuccoandstone.com',
        'candelluxsklep.pl',
        'candiceloves.us',
        'candlehandmade.com',
        'candlewooddentalcentre.com.au',
        'candy-glam-hp.com',
        'candycrushshop.com',
        'candypeople.se',
        'candytiner.com',
        'canoncdriverq3.pen.io',
        'canrioloadm.gq',
        'canrole.com',
        'canvas.gloverid.site',
        'canyougethighofftizanidine.blogspot.com',
        'canzoni.ru',
        'capacitacionyaprendizaje.com',
        'capture-room.com',
        'carabela.com.do',
        'carapics.com',
        'cardiosport.com.ua',
        'cardsdumps.com',
        'cardsharp1.ru',
        'cardul.ru',
        'carfax.com.ua',
        'carina-sy.de',
        'carloans.com',
        'carmuffler.net',
        'cars-modification.net',
        'carsdined.org',
        'carson.getenjoyment.net',
        'carsplate.com',
        'carstrends2015.com',
        'cartechnic.ru',
        'cartierbracelet.xyz',
        'cartierbraceletsreplica.pw',
        'cartierjusteunclou.xyz',
        'cartierlove.xyz',
        'cartierlove2u.com',
        'cartierlove2u.xyz',
        'cartierlovebracelet.xyz',
        'cartierlovebraceletreplica.xyz',
        'cartierloveringreplica.xyz',
        'cartierlovestore.com',
        'cartierlovestore.xyz',
        'cartierreplica.pw',
        'cartierreplica.top',
        'cartierreplica.win',
        'cartierreplica.xyz',
        'cartierring.xyz',
        'cartiertrinity.xyz',
        'cartierwatch.xyz',
        'cartujano-pre.de',
        'casablancamanor.co.za',
        'cascadelink.org',
        'cashkitten-a.akamaihd.net',
        'cashonads.com',
        'casinorewards.info',
        'casinos4dummies.co.uk',
        'casite-513049.cloudaccess.net',
        'castingbank.ru',
        'catalogs-parts.com',
        'caulderwoodkennels.com',
        'caveavins.fr',
        'cayado.snn.gr',
        'cb.iphantom.com',
        'cbb1smartlist12.click',
        'cbcseward.com',
        'cbox.ws',
        'ccbill.com',
        'cctva.tv',
        'cdn.walkme.com',
        'cdnanalytics.xyz',
        'cdncash.com',
        'cdncash.net',
        'cdncash.org',
        'cdnnetwok.xyz',
        'cejewelry.xyz',
        'celebsopics.com',
        'cellfun.mobi',
        'cementaresearch.se',
        'cenokos.ru',
        'cenoval.ru',
        'centraletermice.us',
        'centrdebut.ru',
        'centre-indigo.org.ua',
        'centrumcoachingu.com',
        'ceotrk.com',
        'cercacamion.it',
        'cete.ru',
        'cezartabac.ro',
        'cfacarrosserie74.com',
        'cfcl.co.uk',
        'cfjump.com',
        'cfsrating.sonicwall.com',
        'cgi2.nintendo.co.jp',
        'charmstroy.info',
        'chastnoeporno.com',
        'chatroulette.life',
        'chatroulette.online',
        'chatroulette.si',
        'chatroulette.video',
        'chatroulette.world',
        'chatseo.com',
        'chcu.net',
        'cheap-pills-norx.com',
        'cheap-trusted-backlinks.com',
        'cheapbarbour.online',
        'cheapbelstaff.online',
        'cheapcigarettesc.info',
        'cheapestjerseys-wholesale.com',
        'cheapestjerseysonwholesale.com',
        'cheapjerseysa.com',
        'cheapjerseysap.com',
        'cheapjerseysbizwholesale.us',
        'cheapjerseysfootballshop.com',
        'cheapmarmot.online',
        'cheapmoncler.pw',
        'cheapmoncler.win',
        'cheapmoncler.xyz',
        'cheapsergiorossi.online',
        'cheapwebsitehoster.com',
        'cheatcode-lita12.rhcloud.com',
        'check-host.net',
        'checkhit.com',
        'checkm8.com',
        'checkpagerank.net',
        'checktext.org',
        'chee-by.biz',
        'chelnytruck.ru',
        'chelyabinsk.xrus.org',
        'cherrypointplace.ca',
        'cherubinimobili.it',
        'chiblackhawks-jerseys.com',
        'chidporn.com',
        'children-learningreading.info',
        'chimiver.info',
        'chinacheapelitejerseys.com',
        'chinaelitecheapjerseys.com',
        'chinajerseyswholesalecoupons.com',
        'chinese-amezon.com',
        'chiptuninger.com',
        'chlooe.com',
        'chocolateslim-en-espana.com',
        'chocolateslim-en-france.com',
        'chocolateslim-original.com',
        'chocolateslim-u-srbiji.com',
        'chocoslim.pro',
        'choice-credit.ru',
        'choosecuisine.com',
        'chorus.terakeet.com',
        'christianlouboutinoutlet.win',
        'christianlouboutinreplica.pw',
        'christianlouboutinreplica.win',
        'christianlouboutinsaleonline.us',
        'christianlouboutinsaleoutletonline.us',
        'christianlouboutinshoes.xyz',
        'chuckguilford.com',
        'ci.ua',
        'cialis-samples.com',
        'cialisovercounteratwalmartusa.com',
        'cialiswithoutadoctor.net',
        'cibpenonptib.flu.cc',
        'cicaki.net',
        'ciekawinki.pl',
        'cienum.fr',
        'cigarpass.com',
        'cineacademy.ru',
        'cinemaenergy-hd.ru',
        'cinemaflix.website',
        'ciproandtizanidine.blogspot.com',
        'circlesl.com',
        'citetick.com',
        'citizenclsdriveri7.pen.io',
        'cityadspix.com',
        'citysecurity.nu',
        'civilwartheater.com',
        'cjmc.info',
        'cjs.com.ru',
        'cl.s7.exct.net',
        'clarithromycin500mg.com',
        'clash-clans.ru',
        'classicakuhni.ru',
        'classiquebijoux.ru',
        'claytransformations.info',
        'clayvasedesigns.tk',
        'clean-start.net',
        'clean-virus-mac.com',
        'cleanallspyware.com',
        'cleanallvirus.com',
        'cleanersoft.com',
        'cleanmypc.com',
        'cleanpcnow.com',
        'cleansearch.net',
        'clevernt.com',
        'clickaider.com',
        'clickbank.net',
        'clickbanksites.info',
        'clickcash.com',
        'clickhype.com',
        'clickintext.net',
        'clickpapa.com',
        'clickprotects.com',
        'clickso.com',
        'clicksor.com',
        'clicksor.net',
        'clicksotrk.com',
        'clickzzs.nl',
        'clipartnew.com',
        'clippingphotoindia.com',
        'clips.ua.ac.be',
        'clknsee.com',
        'clksite.com',
        'clmforexeu.com',
        'clodo.ru',
        'clothesforcash.com',
        'club-lukojl.ru',
        'club-musics.ru',
        'club-samodelkin.ru',
        'clubfashionista.com',
        'cmd.kz',
        'cmhomestayagency.com',
        'cntravelre.com',
        'co.lumb.co',
        'coaching-netz.info',
        'cobaltpro.ru',
        'cocyq.inwtrade.com',
        'coderstate.com',
        'codq.info',
        'codysbbq.com',
        'cognitiveseo.com',
        'coin-hive.com',
        'coindirect.io',
        'coinsspb.com',
        'coldfilm.ru',
        'colehaanoutlet.store',
        'collegeessay19.blogspot.ru',
        'collegerentals.com',
        'colobit.biz',
        'com-cleaner.systems',
        'com-onlinesupport.host',
        'com-onlinesupport.site',
        'com-secure.download',
        'com-supportcenter.website',
        'comeondog.info',
        'cometorussia.net',
        'comissionka.net',
        'communisave.co.za',
        'community.allhiphop.com',
        'companies-catalog.com',
        'compiko.info',
        'compliance-alex.top',
        'compliance-alex.xyz',
        'compliance-alexa.top',
        'compliance-alexa.xyz',
        'compliance-andrew.top',
        'compliance-andrew.xyz',
        'compliance-barak.top',
        'compliance-barak.xyz',
        'compliance-brian.top',
        'compliance-brian.xyz',
        'compliance-checker-7.info',
        'compliance-checker.info',
        'compliance-don.top',
        'compliance-don.xyz',
        'compliance-donald.xyz',
        'compliance-elena.top',
        'compliance-elena.xyz',
        'compliance-fred.top',
        'compliance-fred.xyz',
        'compliance-george.top',
        'compliance-george.xyz',
        'compliance-irvin.top',
        'compliance-irvin.xyz',
        'compliance-ivan.top',
        'compliance-ivan.xyz',
        'compliance-jack.top',
        'compliance-jane.top',
        'compliance-jess.top',
        'compliance-jessica.top',
        'compliance-john.top',
        'compliance-josh.top',
        'compliance-julia.top',
        'compliance-julianna.top',
        'compliance-margo.top',
        'compliance-mark.top',
        'compliance-mary.top',
        'compliance-nelson.top',
        'compliance-olga.top',
        'compliance-viktor.top',
        'compliance-walt.top',
        'compliance-walter.top',
        'compliance-willy.top',
        'compucelunlock.net',
        'computernetworksonline.com',
        'comsysnet.com',
        'conboy.us',
        'concealthyself.com',
        'conciergegroup.org',
        'concordexoticrentals.com',
        'confib.ifmo.ru',
        'connectingsingles.com',
        'connectionstrenth.com',
        'conocer-sanabria.com',
        'consorzioilmosaico.org',
        'constantaservice.net',
        'construmac.com.mx',
        'contentlook.co',
        'contentsexpress.com',
        'contextualyield.com',
        'continent-e.tv',
        'converse.ddsoldes.fr',
        'cookie-law-enforcement-aa.xyz',
        'cookie-law-enforcement-ee.xyz',
        'cookie-law-enforcement-ff.xyz',
        'cookie-law-enforcement-hh.xyz',
        'cookielawblog.wordpress.com',
        'cookingmeat.ru',
        'cool-wedding.net',
        'coolbar.pro',
        'coolgamechannel.com',
        'coolgramgoods.com',
        'coolingoods.com',
        'coolwallpapers-hd.com',
        'coolyarddecorations.com',
        'coop-gamers.ru',
        'copblock.org',
        'copenergo.ru',
        'copro.pw',
        'coprofam.org',
        'copypaste.traderzplanet.in',
        'copyrightclaims.org',
        'cordstrap.cc',
        'cornerstone-countertops.com',
        'cornomase.win',
        'corta.co',
        'coslab.club',
        'cosmetic.donna7753191.ru',
        'cosmeticswomens-womensports.rhcloud.com',
        'cottageofgrace.com',
        'cougfan.info',
        'counciltally.com',
        'countbertwistdisp26.soup.io',
        'counter.bloke.com',
        'counter.yadro.ru',
        'counterbot.com',
        'countercrazy.com',
        'country-chic.ru',
        'courtshipgift.com',
        'covadhosting.biz',
        'covetnica.com',
        'cowblog.fr',
        'cowlmash.com',
        'cpabegins.ru',
        'cpajunkies.com',
        'crackguru.tk',
        'cracksplanet.com',
        'crackzplanet.com',
        'craftburg.ru',
        'crafthubs.com',
        'craftinsta.ru',
        'cranly.net',
        'crazyboost.pro',
        'crazyprotocol.com',
        'crd.clan.su',
        'creams.makeforum.eu',
        'creativehutindia.com',
        'creatives.adbetclickin.pink',
        'credit-respect.ru',
        'creditmoney.com.ua',
        'creditnation.ru',
        'creditwell.ru',
        'crest-poloski.ru',
        'crest3d.ru',
        'crirussian.ru',
        'crynet.cc',
        'cryptoswap.biz',
        'crystalslot.com',
        'cs-passion.pl',
        'cscwtalkto.site',
        'csgo4.win',
        'cubook.supernew.org',
        'cubs-jerseys.us',
        'culad.com',
        'culturevie.info',
        'cupday.com',
        'custodieva.ru',
        'custom-electric-guitar.com',
        'custom-product-labels.com',
        'customboxes4less.com',
        'customcatchcan.com',
        'customchocolate.business-for-home.com',
        'customcollegeessays.net',
        'customergrowthsystems.com',
        'customerguru.in',
        'customerpromos-a.akamaihd.net',
        'customsua.com.ua',
        'cutalltheshit.com',
        'cv.wallhade.co',
        'cvety24.by',
        'cxpromote.com',
        'cyclobenzaprinevstizanidine.blogspot.com',
        'cymbaltaandtizanidine.blogspot.com',
        'cypernhuset.se',
        'cyprusbuyproperties.com',
        'cyse.tk',
        'czat.wp.pl',
        'd-black.bz',
        'd0t.ru',
        'd2jsp.org',
        'dafatiri.com',
        'dailyfinancefix.com',
        'dailyrank.net',
        'dailystrength.org',
        'dairyindia.in',
        'dalavia.ru',
        'dame-ns.kz',
        'damedingel.ya.ru',
        'danashop.ru',
        'danceuniverse.ru',
        'dandiyabeats.in',
        'daneshetabiat.com',
        'dangphoto.trade',
        'danschawbel.com',
        'daooda.com',
        'daptravel.com',
        'darkbooks.org',
        'darmebel.com.ua',
        'darodar.com',
        'data-mining.tk',
        'data.vtc.pw',
        'data1.scopich.com',
        'dataloading.net',
        'date-withme.com',
        'dating-app.ru',
        'dating-time-now.com',
        'datract.com',
        'datsun-do.com',
        'davebestdeals.com',
        'day-news.info',
        'daydream-studio.ru',
        'dayibiao.com',
        'daymusam.com',
        'dbmkfhqk.bloger.index.hr',
        'dcj-nn.ru',
        'ddlmega.net',
        'ddospanel.com',
        'ddpills.com',
        'ddsoldes.fr',
        'de.zapmeta.com',
        'deadlinkchecker.com',
        'dealighted.com',
        'dealitright.click',
        'dealwifi.com',
        'deanmoore.ie',
        'dear-diary.ru',
        'decenttools.com',
        'decoratinghomes.ga',
        'decorationspcs.com',
        'decorazilla.com',
        'deda-moroza-zakaz.ru',
        'defenderxtactical.com',
        'degerlund.net',
        'dekoration.us',
        'dekorkeramik.ru',
        'delayreferat.ru',
        'delfin-aqua.com.ua',
        'dellalimov.com',
        'delta-line.men',
        'deluxedumps.com',
        'demenageur.com',
        'demian.kz',
        'den-noch24.ru',
        'dengi-pod-zalog-nedvizhimosti.ru',
        'deniven.1bb.ru',
        'dentalpearls.com.au',
        'deplim.com',
        'depositfiles-porn.ga',
        'derevesendeco.com',
        'descargar-musica-gratis.net',
        'deshevo-nedorogo.ru',
        'design-ideas.info',
        'design-lands.ru',
        'designdevise.com',
        'destinationrealestate.com',
        'detalizaciya-tut.biz',
        'detective01.ru',
        'detki-opt.ru',
        'detskie-konstruktory.ru',
        'detskie-zabavi.ru',
        'detsky-nabytek.info',
        'deutschehobbyhuren.net',
        'deutschland123.de',
        'dev-seo.blog',
        'dev.citetick.com',
        'dev33.dioniqlabb.se',
        'dev78.dioniqlabb.se',
        'devochki.top',
        'dfiles.me',
        'dfwu1013.info',
        'dfwu1019.info',
        'diarioaconcagua.com',
        'dichvuvesinhhanoi.com',
        'dickssportinggoods.com',
        'diegolopezcastan.com',
        'diesel-parts28.ru',
        'dieswaene.com',
        'dieta-personalna.pl',
        'diffbot.com',
        'digest-project.ru',
        'digilander.libero.it',
        'digital-sale.su',
        'digital-video-processing.com',
        'digitalfaq.com',
        'dignitasdata.se',
        'dikqlyremy.info',
        'dikx.gdn',
        'dildofotzen.net',
        'dimaka.info',
        'diminishedvalueoforegon.com',
        'dimkino.ru',
        'dinkolove.ya.ru',
        'dipstar.org',
        'directivepub.com',
        'directrev.com',
        'discountbarbour.online',
        'discountliv.com',
        'discovertreasure-a.akamaihd.net',
        'discovertreasurenow.com',
        'dispo.de',
        'disruptingdinnerparties.com',
        'distver.ru',
        'div.as',
        'divatraffic.com',
        'dividendo.ru',
        'divisioncore.com',
        'divku.ru',
        'diy-handmade-ideas.com',
        'djekxa.ru',
        'djihispano.com',
        'djonwatch.ru',
        'djstools.com',
        'dktr.ru',
        'dkvorota.ru',
        'dlya-android.org',
        'dms-sw.ru',
        'dnepr-avtospar.com.ua',
        'dnepropetrovsk.mistr-x.org',
        'dneprsvet.com.ua',
        'dnsrsearch.com',
        'docs4all.com',
        'docsportal.net',
        'docstoc.com',
        'doctissimo.fr',
        'doctormakarova.ru',
        'documentbase.net',
        'documentsite.net',
        'dodlive.mil',
        'doeco.ru',
        'dogbreedspicture.net',
        'dogclothing.store',
        'dogoimage.com',
        'dogsrun.net',
        'dojki-hd.com',
        'dokfilms.net',
        'doktoronline.no',
        'dokumentalkino.net',
        'dollartree.info',
        'domain-submit.info',
        'domain-tracker.com',
        'domain.webkeyit.com',
        'domain2008.com',
        'domainanalyzing.xyz',
        'domaincdn.xyz',
        'domaincheck.io',
        'domaincrawler.com',
        'domaineaneblanc.com',
        'domainroam.win',
        'domainsatcost.com',
        'domainsphoto.com',
        'domashneeruporno.com',
        'domcran.net',
        'domik-derevne.ru',
        'dominateforex.ml',
        'domination.ml',
        'domini.cat',
        'dominterior.org',
        'domoysshop.ru',
        'domznaniy.ru',
        'donna7753191.ru',
        'donvito.unas.cz',
        'dorratex.tn',
        'doska-vsem.ru',
        'dostavimvdom.ru',
        'dostavka-v-krym.com',
        'dostavka-v-ukrainu.ru',
        'dosug-lux.ru',
        'dotnetdotcom.org',
        'doublepimp.com',
        'download-of-the-warez.blogspot.com',
        'download-wallpaper.net',
        'downloaddy.net',
        'downloadeer.net',
        'downloader12.ru',
        'downloadkakaotalk.com',
        'downloadmefiranaratb1972.xpg.com.br',
        'downloads-whatsapp.com',
        'downtuptv.gq',
        'downvids.net',
        'doxyporno.com',
        'doyouknowtheword-flummox.ml',
        'dpihatinh.gov.vn',
        'dprtb.com',
        'dptaughtme.com',
        'drhomes.biz',
        'drillsaw.ru',
        'driving.kiev.ua',
        'drivotracker.com',
        'droidlook.net',
        'drugs-no-rx.info',
        'drugspowerstore.com',
        'drugstoreforyou.com',
        'drunkenstepfather.com',
        'drunkmoms.net',
        'drupa.com',
        'druzhbany.ru',
        'druzhininevgeniy63.blogspot.com',
        'dstroy.su',
        'dtnlyss.com',
        'dumpsmania24.com',
        'duplicashapp.com',
        'dustyorate.com',
        'dvd-famille.com',
        'dverimegapolis.ru',
        'dvervmoskvu.ru',
        'dvr.biz.ua',
        'dvrlists.com',
        'dynainbox.com',
        'dyshagi.ru',
        'dyt.net',
        'e-avon.ru',
        'e-biznes.info',
        'e-buyeasy.com',
        'e-collantes.com',
        'e-commerce-seo.com',
        'e-commerce-seo1.com',
        'e-kwiaciarz.pl',
        'e-poker-2005.com',
        'e2click.com',
        'e705.net',
        'eachdayisagift.review',
        'eandsgallery.com',
        'eaplay.ru',
        'earl-brown.info',
        'earn-from-articles.com',
        'earncash.com.ua',
        'eas-seo.com',
        'easycommerce.cf',
        'easync.io',
        'easyshoppermac.com',
        'easytuningshop.ru',
        'easyukraine.com',
        'ec-file.info',
        'ecommerce-seo.com',
        'ecommerce-seo.org',
        'econom.co',
        'ecookna.com.ua',
        'ecxtracking.com',
        'ed-shop01.ru',
        'edelstahlschornstein-123.de',
        'edge.sharethis.com',
        'editmedios.com',
        'editors.choice6912650.hulfingtonpost.com',
        'ednorxmed.com',
        'educatemetv.com',
        'education-cz.ru',
        'educontest.net',
        'edudocs.net',
        'eduinfosite.com',
        'eduserver.net',
        'edwinkonijn.com.au',
        'ee77ee.com',
        'efkt.jp',
        'efnor-ac.com',
        'ege-russian.ru',
        'egovaleo.it',
        'egvar.net',
        'ekaterinburg.xrus.org',
        'ekn-art.se',
        'ekobata.ru',
        'ekosmetyki.net.pl',
        'ekspertmed.com',
        'ekspresihati.info',
        'ekto.ee',
        'el-nation.com',
        'eladkarako.com',
        'eladkarako.github.io',
        'eldiariodeguadalajara.com',
        'election.interferencer.ru',
        'electricwheelchairsarea.com',
        'electrik-avenue.com',
        'electro-prom.com',
        'electronicadirect.com',
        'elektir.ru',
        'elektrischezi.canalblog.com',
        'elektrischeziga.livejournal.com',
        'elektrischezigarette1.blog.pl',
        'elektrischezigarette1.onsugar.com',
        'elektrischezigarette2.devhub.com',
        'elektrischezigarette2.onsugar.com',
        'elektrischezigarettekaufen2.cowblog.fr',
        'elektrischezigaretten1.blogse.nl',
        'elektrischezigaretten2.beeplog.com',
        'elektroniksigaraankara.info',
        'elektronischezi.livejournal.com',
        'elektronischezigarette2.mex.tl',
        'elektronischezigarettekaufen1.beeplog.com',
        'elektronischezigarettekaufen1.myblog.de',
        'elektronischezigarettekaufen2.tumblr.com',
        'elektrozigarette1.dreamwidth.org',
        'elektrozigarette2.webs.com',
        'elektrozigarette2.wordpressy.pl',
        'elektrozigarettekaufen1.devhub.com',
        'elektrozigarettekaufen2.blogse.nl',
        'elektrozigaretten1.postbit.com',
        'elektrozigaretten1.tumblr.com',
        'elektrozigaretten1.webs.com',
        'elektrozigaretten2.yn.lt',
        'elidelcream.weebly.com',
        'elite-sex-finders.com',
        'elitedollars.com',
        'elitepcgames.com',
        'elitesportsadvisor.com',
        'elkacentr.ru',
        'elmacho.xyz',
        'elmifarhangi.com',
        'eloconcream.blogspot.com',
        'eloxal.ru',
        'elstal.com.pl',
        'eluxer.net',
        'elvel.com.ua',
        'elvenar.com',
        'elvenmachine.com',
        'emailaccountlogin.co',
        'embedle.com',
        'emediate.eu',
        'emergencyneeds.org',
        'emerson-rus.ru',
        'empathica.com',
        'empirepoker.com',
        'empis.magix.net',
        'en.altezza.travel',
        'en.home-task.com',
        'enbersoft.com',
        'encodable.com',
        'energy-ua.com',
        'energydiet-info.ru',
        'energydiet24.ru',
        'eng-lyrics.com',
        'enge-fotzen.info',
        'enginebay.ru',
        'engines-usa.com',
        'englate.com',
        'englishdictionaryfree.com',
        'englishgamer.com',
        'enhand.se',
        'enskedesquashclub.se',
        'enternet.ee',
        'enthuse.computernetworksonline.com',
        'envaseslotusama.com',
        'eonpal.com',
        'eorogo.top',
        'epicbrogaming.com',
        'epngo.bz',
        'eralph.tk',
        'erectile.bid',
        'eredijovon.com',
        'ereko.ru',
        'ero-advertising.com',
        'eropornosex.ru',
        'erot.co',
        'erotik-kostenlos.net',
        'erotik0049.com',
        'erotikchat-24.com',
        'erotikstories.ru',
        'erotiktreff24.info',
        'erotische-geschichten-xxl.com',
        'errorfixing.space',
        'ertelecom.ru',
        'es5.com',
        'escort-russian.com',
        'escortplius.com',
        'escortslet.net',
        'esfchat.tk',
        'eshop.md',
        'eshop4u.jp',
        'esnm.ru',
        'esopini.com',
        'espaceinventoristes.com',
        'essay-edu.biz',
        'essay-writing.work',
        'essayassist.com',
        'essaypro.com',
        'essayservicewriting.org',
        'este-line.com.ua',
        'estelight.ru',
        'estibot.com',
        'etm-consult.de',
        'etotupo.ru',
        'etur.ru',
        'eu-cookie-law.blogspot.com',
        'eu-cookie-law.info',
        'eugenevaultstorage.com',
        'eupornstar.info',
        'euromasterclass.ru',
        'euronis-free.com',
        'europages.com.ru',
        'european-torches.ru',
        'europeanwatches.ru',
        'eurosamodelki.ru',
        'euroskat.ru',
        'evaashop.ru',
        'evehemming.blogspot.com.au',
        'evening-dating-club.info',
        'event-tracking.com',
        'everflora.ru',
        'everypony.ru',
        'everytalk.tv',
        'evidencecleanergold.com',
        'evogarage.com',
        'evrotekhservis.ru',
        'ewebarticle.info',
        'excaliburfilms.com',
        'exchangeit.gq',
        'exchanges-bet.com',
        'excitacao.com',
        'excitacion.info',
        'exct.net',
        'exdocsfiles.com',
        'executehosting.com',
        'exhibitionplus.eu',
        'exmasters.com',
        'exoclick.com',
        'exoneration-project.us',
        'exonline.info',
        'expdom.com',
        'expertblog.info',
        'expertnaya-ocenka.ru',
        'exportshop.us',
        'expresstoplivo.ru',
        'extads.net',
        'extener.org',
        'extlabs.io',
        'extlinks.com',
        'extrabot.com',
        'extractorandburner.com',
        'extremal-blog.com',
        'extremepornos.net',
        'extremez.net',
        'extstat.com',
        'eyelike.com.ua',
        'eyemagination.com',
        'eyes-on-you.ga',
        'eyessurgery.ru',
        'eywords-monitoring-your-success.com',
        'ez8motelseaworldsandiego.com',
        'ezb.elvenmachine.com',
        'ezigarettekaufen.myblog.de',
        'ezigarettekaufen1.hpage.com',
        'ezigarettekaufen2.blox.pl',
        'ezigarettekaufen2.mpbloggar.se',
        'ezigarettekaufen2.yolasite.com',
        'ezigarettenkaufen1.deviantart.com',
        'ezigarettenkaufen1.pagina.gr',
        'ezigarettenkaufen2.dreamwidth.org',
        'ezigarettenshop1.yolasite.com',
        'ezigarettenshop2.myblog.de',
        'ezigarettenshop2.postbit.com',
        'ezigaretteshop.webs.com',
        'ezigaretteshop2.mywapblog.com',
        'ezigaretteshop2.vefblog.net',
        'ezofest.sk',
        'ezrvrentals.com',
        'f-loaded.de',
        'f-online.de',
        'f00kclan.de',
        'f012.de',
        'f07.de',
        'f0815.de',
        'f1nder.org',
        'f5mtrack.com',
        'fable.in.ua',
        'face.hostingx.eu',
        'facebook-mobile.xyz',
        'facecup.top',
        'factorynightclub.com',
        'failingmarriege.blogspot.com',
        'fakehandbags.xyz',
        'falcoware.com',
        'falllow.gq',
        'familienzahnaerzte.com',
        'family1st.ca',
        'familyholiday.ml',
        'familyphysician.ru',
        'famix.xyz',
        'fandlr.com',
        'fanoboi.com',
        'fanpagerobot.com',
        'fantasticpixcool.com',
        'faptitans.com',
        'faracontrol.ir',
        'farm26.ru',
        'farmingworm.com',
        'farmprofi.net',
        'fashion-mk.net',
        'fashion-stickers.ru',
        'fashionavenuegame.com',
        'fashionindeed.ml',
        'fast-wordpress-start.com',
        'fastcrawl.com',
        'fastfixing.tech',
        'fatfasts-4tmz.com',
        'fatmaelgarny.com',
        'favorcosmetics.com',
        'favoritemoney.ru',
        'favornews.com',
        'faz99.com',
        'fba-mexico.com',
        'fbdownloader.com',
        'fdzone.org',
        'fealq.com',
        'fearcrow.com',
        'feargames.ru',
        'feel-planet.com',
        'feeriaclub.ru',
        'fefo.gdn',
        'fellowshipoftheminds.com',
        'femdom.twiclub.in',
        'femmesdenudees.com',
        'fenoyl.batcave.net',
        'feorina.ru',
        'ferieboligkbh.dk',
        'fermersovet.ru',
        'ferretsoft.com',
        'ferrotodo.com',
        'fertilitetsradgivningen.se',
        'fetishinside.com',
        'fetroshok.ru',
        'fettefrauen.net',
        'ff30236ddef1465f88547e760973d70a.com',
        'fickblock18.com',
        'fickenbumsen.net',
        'fickenprivat.info',
        'fickkontakte.org',
        'fickkontaktehobbyhuren.com',
        'fickluder69.com',
        'fidelityfunding.com',
        'fifa-coins.online',
        'figuringmoneyout.com',
        'fikasound.tk',
        'fil.ru',
        'filefilter.weebly.com',
        'filerockstar298.weebly.com',
        'filesclub.net',
        'filesdatabase.net',
        'filesmonster.porn',
        'filesvine.com',
        'filkhbr.com',
        'fillmewithhappiness.com',
        'film-one.ru',
        'filmbokep69.com',
        'filmetricsasia.com',
        'filmfanatic.com',
        'filmgo.ru',
        'filmidivx.com',
        'filunika.com.ru',
        'financehint.eu',
        'financeloan.us',
        'financepoints.eu',
        'financetip.eu',
        'find1friend.com',
        'findacheaplawyers.com',
        'findanysex.com',
        'findclan.org',
        'findpik.com',
        'findsexguide.com',
        'findthe.pet',
        'finejewelryshop.ru',
        'finemanteam.com',
        'finstroy.net',
        'finteks.ru',
        'finuse.com',
        'fireads.men',
        'firesub.pl',
        'firma-legion.ru',
        'firstdrugmall.ru',
        'firstsiteguide.com',
        'fishingwholesale.us',
        'fishtauto.ru',
        'fitfloponline.store',
        'fitness-video.net',
        'fitnesspiks.com',
        'fiuxy.com',
        'fivedwld.cf',
        'fiverr.com',
        'fix-website-errors.com',
        'flagcounter.me',
        'flash4fun.com',
        'flashahead.info',
        'flashbannernow.com',
        'flashlarevista.com',
        'flavors.me',
        'flex4launch.ru',
        'flipper.top',
        'flirt4free.com',
        'floating-share-buttons.com',
        'flooringinstallation-edmonton.com',
        'florida-tourism.net',
        'floridahuntingfishingadventures.com',
        'floridamhca.org',
        'floridamobilebillboards.com',
        'flowersbazar.com',
        'flowwwers.com',
        'flprog.com',
        'flytourisme.org',
        'fm-upgrade.ru',
        'focalink.com',
        'fodelsedagspresenter.nu',
        'fok.nl',
        'folowsite.com',
        'food.dtu.dk',
        'foodcrafts.website',
        'footbalive.org',
        'footballfarrago.com',
        'fordsonmajbor.cf',
        'forensicpsychiatry.ru',
        'forex-indextop20.ru',
        'forex-procto.ru',
        'forex.osobye.ru',
        'forex21.ru',
        'forexgb.ru',
        'forexunion.net',
        'forminecrafters.ru',
        'forms-mtm.ru',
        'formseo.com',
        'formulaantiuban.com',
        'formularz-konkurs.tk',
        'forodvd.com',
        'forpackningsutveckling.se',
        'forpostlock.ru',
        'forsex.info',
        'fortevidyoze.net',
        'fortunejack.com',
        'fortwosmartcar.pw',
        'forum-engineering.ru',
        'forum.doctissimo.fr',
        'forum.poker4life.ru',
        'forum.tvmir.org',
        'forum20.smailik.org',
        'forum69.info',
        'forumprofi.de',
        'forums.d2jsp.org',
        'forums.toucharcade.com',
        'foto-basa.com',
        'foto-sisek.porngalleries.top',
        'foto-telok.net',
        'foto-weinberger.at',
        'fotopop.club',
        'fototravel.eu',
        'fotoxxxru.com',
        'fotzen-ficken.com',
        'foxinsocks.ru',
        'foxtechfpv.com',
        'foxweber.com',
        'foxydeal.com',
        'fr-bearings.ru',
        'fr.netlog.com',
        'franecki.net',
        'franklinfire.co',
        'frbizlist.com',
        'frcls.fr',
        'freakycheats.com',
        'free-deals.faith',
        'free-fb-traffic.com',
        'free-fbook-traffic.com',
        'free-floating-buttons.com',
        'free-gluten.ru',
        'free-laptop-reward.com',
        'free-share-buttons.blogspot.com',
        'free-share-buttons.com',
        'free-share-buttons.top',
        'free-social-buttons.com',
        'free-social-buttons.xyz',
        'free-stock-illustration.com',
        'free-today.com',
        'free-traffic.xyz',
        'free-video-tool.com',
        'free411games.com',
        'freecamdollars.com',
        'freegamesplay.online',
        'freejabs.com',
        'freelifetimefuckbook.com',
        'freelinkbuilding.website.tk',
        'freelotto.com',
        'freemags.cc',
        'freemaintenancesysforpcandmac.top',
        'freenode.info',
        'freenom.link',
        'freeseedsonline.com',
        'freesitetest.com',
        'freetangodownload.com',
        'freeuploader.com',
        'freeuploader.ml',
        'freewareseek.com',
        'freewebs.com',
        'freewhatsappload.com',
        'freewlan.info',
        'frequiry.com',
        'freshberry.com.ua',
        'freshdz.com',
        'freshmac.space',
        'freshsuperbloop.com',
        'freshwallpapers.info',
        'freza-sverlo.ru',
        'frighteningremain.cf',
        'frivgame250.com',
        'froggytube.com',
        'front.ru',
        'front.to',
        'frustrated-favorable.gq',
        'frvo.alptandem.ru',
        'fsakhalin.ru',
        'fsalas.com',
        'ftns.ru',
        'fuck-paid-share-buttons.xyz',
        'fuckingawesome.com',
        'fuckmill.com',
        'fuel-gas.com',
        'fugarif.ga',
        'fullfileaccess.com',
        'fullgirl.ru',
        'fun-mobi.pl',
        'fun2cell.net',
        'funcrushgames.com',
        'fungamelands.com',
        'fungirlsgames.net',
        'funnel.co.za',
        'funnymama.com',
        'funnypica.com',
        'funponsel.com',
        'funtoonez.com',
        'fusoradio.info',
        'futbolkisales.ru',
        'fx-brokers-review.com',
        'fxgallery.com',
        'fxtips.ru',
        'fyl.com.ru',
        'fym.com.ru',
        'fyxabomiw.ru',
        'fz139.ttk.ru',
        'g.starmoe.xyz',
        'g33.org',
        'g7m.pl',
        'gabeshop.ru',
        'gael-s.ru',
        'gagrasector.ru',
        'galaxy-family.ru',
        'galaxyflowers.ru',
        'galaxys6manual.info',
        'galeon.com',
        'gallerily.com',
        'gallery.rennlist.com',
        'galleryawesome.com',
        'gallerylisting.com',
        'gallictures.com',
        'gambarkatabaru.com',
        'gambarkataku.co',
        'gambarxkata.co',
        'gamblingnerd.com',
        'game-mmorpg.net',
        'game-top.su',
        'game300.ru',
        'gamebackyard.com',
        'gamedayassist.com',
        'gamedayhouse.com',
        'gameonasia.com',
        'gameplexcity.com',
        'gameprimary.com',
        'gamerextra.com',
        'gamerscorps.com',
        'games.kolossale.ru',
        'gamesprite.me',
        'gamevalue7.weebly.com',
        'gamewrath.com',
        'gamezblox.com',
        'gaming-journal.com',
        'gamingspark.com',
        'garciniaxt.us',
        'gardene.ru',
        'gate5.co.za',
        'gateway.zscalerone.net',
        'gateway.zscalertwo.net',
        'gavuer.ru',
        'gay-file.com',
        'gay.adultgalls.com',
        'gaygalls.net',
        'gaytube.com',
        'gayxperience.com',
        'gaz-voshod.ru',
        'gazobeton-p.com.ua',
        'gazoblok.net.ua',
        'gazporno.com',
        'gcup.ru',
        'gdcentre.ru',
        'gdebestkupit.ru',
        'ge0ip.com',
        'ge0ip.net',
        'ge0ip.org',
        'gearcraft.us',
        'gearsadspromo.club',
        'geckoandfly.com',
        'geile-lelly.eu',
        'geilehausfrauen.net',
        'geileweiber.tk',
        'gelezki.com',
        'gemara.com',
        'gembird.com',
        'gemgrab-a.akamaihd.net',
        'generalporn.org',
        'generic-pills-online.com',
        'genericlowlatencyasiodriverhq.aircus.com',
        'genericviagrasildenafiled.net',
        'generousdeal-a.akamaihd.net',
        'genetworx.com',
        'gentamicineyedrops.blogspot.com',
        'geoads.com',
        'germes-trans.com',
        'germetiki.com.ua',
        'get-free-social-traffic.com',
        'get-free-traffic-now.com',
        'get-seo-domain.com',
        'get-your-social-buttons.info',
        'getaclueamerica.com',
        'getdot.ru',
        'getlaid-xxxhookupdirect.com',
        'getlamborghini.ga',
        'getmiro.com',
        'getmyads24.com',
        'getoutofdebtfree.org',
        'getpopunder.com',
        'getprismatic.com',
        'getresponse.com',
        'getridofstretchmarks.org',
        'gettpromos.com',
        'gfaq.ru',
        'gg-arena.ru',
        'gg.zzyjxs.com',
        'ggiaro.com',
        'ghazel.ru',
        'ghernnqr.skyrock.com',
        'gheus.altervista.org',
        'ghostvisitor.com',
        'gifspics.com',
        'gigablast.com',
        'gigapeta.com',
        'gilbertbanda.net',
        'gilsonchiro.xyz',
        'girlgamerdaily.com',
        'girlporn.ru',
        'girls-ufa.ru',
        'girlsatgames.ru',
        'girlsfuckdick.com',
        'girlspicsa.com',
        'given2.com',
        'gk-atlant.info',
        'gk170.ru',
        'gktt.ru',
        'gkvector.ru',
        'glall.ru',
        'glasof.es',
        'glass-msk.ru',
        'glastecfilms.com.my',
        'glavprofit.ru',
        'glavtral.ru',
        'glcomputers.ru',
        'glicol.kz',
        'global-ics.co.za',
        'globalscam.ga',
        'globalsurfari.com',
        'globatur.ru',
        'globetrotting-culture.ru',
        'glogow.pl',
        'glopages.ru',
        'gloverid.site',
        'gne8.com',
        'gnuetella.com',
        'go2album.com',
        'go2jump.org',
        'go2mike.ru',
        'goatse.ru',
        'gobongo.info',
        'goforexvps.com',
        'gogalleryawesome.com',
        'gogps.me',
        'gojiberriess.apishops.ru',
        'gok-kasten.net',
        'golaya.pw',
        'goldadpremium.com',
        'goldandcard.ru',
        'golden-catalog.pro',
        'golden-praga.ru',
        'goldenggames.com',
        'goldpanningtools.com',
        'golfresa.lucania.se',
        'golmau.host.sk',
        'gomusix.com',
        'gonextmedia.com',
        'goo.ne.jp',
        'good-mummy.ru',
        'goodhousekeeping.com',
        'goodhumor24.com',
        'goodnightjournal.com',
        'goodprotein.ru',
        'goodwriterssales.com',
        'googglet.com',
        'google-liar.ru',
        'googlefeud.com',
        'googlemare.com',
        'googlepositions.com',
        'googleweblight.com',
        'googlsucks.com',
        'googst2.ru',
        'goosefishpost.bid',
        'gopixdatabase.com',
        'gopro-online.info',
        'gorabagrata.ru',
        'goroda-vsego-mira.ru',
        'gorodservis.ru',
        'gosarhivrt.ru',
        'gosmeb.ru',
        'gosreg.amchs.ru',
        'gotcher.us',
        'gotomontenegro.net',
        'gotorussia.com',
        'gotwebsite1.com',
        'gourcy.altervista.org',
        'gov.yanao.ru',
        'gowreckdiving.com',
        'gox.com.ua',
        'gpirate.com',
        'gpms.org.my',
        'gq-catalog.gq',
        'grand-chlen.ru',
        'graphics8.info',
        'graphicwe.org',
        'graphid.com',
        'gratis-sexkontakte.com',
        'gratuitbaise.com',
        'greatfind-a.akamaihd.net',
        'greatgrace.ru',
        'greatzip.com',
        'green-tea.tv',
        'greendream.com.ua',
        'greenzaim.ru',
        'gribkovye-zabolevaniya.com',
        'gribokstop.com',
        'grizzlysgrill.com',
        'groupmoney.ru',
        'growboxbl.ru',
        'growmyfunds.ca',
        'growshop.es',
        'grtyi.com',
        'grupografico-pilar.com.ar',
        'gsasearchengineranker.pw',
        'gsasearchengineranker.site',
        'gsasearchengineranker.space',
        'gsasearchengineranker.top',
        'gsasearchengineranker.xyz',
        'gsasearchenginerankerdiscount.com',
        'gsbs.com.ua',
        'gsmlab.pl',
        'gsmtlf.ru',
        'gsou.cf',
        'gstatey.net',
        'gta-club.ru',
        'gta-top.ru',
        'gtopstats.com',
        'guardlink.com',
        'guardlink.org',
        'guge.io',
        'guiadeserraazul.com',
        'guigyverpo.cf',
        'guildebzh.info',
        'guitar-master.org',
        'gungamesz.com',
        'guod.me',
        'guruofcasino.com',
        'gwagka.com',
        'gwebtools.com',
        'gwebtools.com.br',
        'gwhwpxbw.bloger.index.hr',
        'gyffu.com',
        'gz2.bbsoldes.fr',
        'h2monline.com',
        'habermetre.com',
        'hacktougroup.ru',
        'hahashka.ru',
        'haikuware.com',
        'hamacapty.com',
        'hamilton.ca',
        'hamptonoaks.ca',
        'handicapbathtubarea.com',
        'handicapvansarea.com',
        'handicapvantoday.com',
        'handsandlegs.ru',
        'hanink.biz.ly',
        'hannasolution.ru',
        'hao123.com',
        'happy.new.yeartwit.com',
        'hasfun.com',
        'hatdc.org',
        'hatedriveapart.com',
        'hauleddes.com',
        'hausfrauensex18.com',
        'haveinc.xyz',
        'havepussy.com',
        'hawaiielectriclight.com',
        'hawaiisurf.com',
        'hayate.biz',
        'hazardky.net',
        'hcate.com',
        'hccoder.info',
        'hchha.com',
        'hd-film.pl',
        'hd-filmy.net',
        'hd720kino.ru',
        'hdapp1008-a.akamaihd.net',
        'hdfreeporno.net',
        'hdimagegallery.net',
        'hdimagelib.com',
        'hdpixent.com',
        'hdpixion.com',
        'hdseriale.pl',
        'hdwallpapers-free.com',
        'hdwalls.xyz',
        'hdxnxxtube.mobi',
        'headpharmacy.com',
        'headpress.ru',
        'healbio.ru',
        'healgastro.com',
        'healing-dysplasia.ru',
        'healmytrauma.info',
        'health-medical-portal.info',
        'healthcarestore.info',
        'heartofbeijing.blogspot.com',
        'heatpower.ru',
        'hebr.myddns-flir.com',
        'helicalpile.us',
        'heliko.no',
        'help.tpu.ru',
        'helpmymacfaster.trade',
        'helvetia.com.ua',
        'hem.passagen.se',
        'hentai-manga.porn',
        'hentaiheroes.com',
        'herehloadibs.cf',
        'hermesbelts.xyz',
        'hermesbirkinhandbagoutlets.com',
        'hermesbracelets.xyz',
        'hermesreplica.pw',
        'hermesreplica.win',
        'herokuapp.com',
        'heroz.fr',
        'hesteel.pl',
        'hetmanship.xyz',
        'hexpilot.com',
        'heygidday.biz',
        'hidefiles.org',
        'hidemyass.com',
        'hifidesign.ru',
        'high-speed1.net',
        'highland-homes.com',
        'highspeed5.net',
        'highstairs-a.akamaihd.net',
        'hikesearch.net',
        'hildinghr.se',
        'histats.com',
        'histock.info',
        'historichometeam.com',
        'hit-men.men',
        'hitcpm.com',
        'hitsbox.info',
        'hiwibyh.bugs3.com',
        'hjaoopoa.top',
        'hkdiiohi.skyrock.com',
        'hkladys.com',
        'hledejvshopech.cz',
        'hmmm.cz',
        'hmywwogw.bloger.index.hr',
        'hobbyhuren-datenbank.com',
        'hobbyhuren24.net',
        'hobild.net',
        'hoholikik.club',
        'hol.es',
        'holidaypics.org',
        'hollywoodactress.info',
        'home-task.com',
        'home.myplaycity.com',
        'homeandhealth.ru',
        'homeart.space',
        'homedecoguide.info',
        'homedecorpicture.us',
        'homedo.fabpage.com',
        'homegardenlova.com',
        'homeinns.com',
        'homelygarden.com',
        'homemade.gq',
        'homemature.net',
        'honyaku.yahoofs.jp',
        'hop.clickbank.net',
        'hopeonthestreet.co.uk',
        'hoporno.com',
        'hornymatches.com',
        'horoshieokna.com',
        'host-protection.com',
        'host-tracker.com',
        'hostcritique.com',
        'hoste.octopis.com',
        'hosting-tracker.com',
        'hostingclub.lk',
        'hostnow.men',
        'hostsshop.ru',
        'hotblog.top',
        'hotchatdate.com',
        'hotdl.in',
        'hotel-mkad.ru',
        'hotelcrocenzi.sm',
        'hotenergy.ru',
        'hotgirlhdwallpaper.com',
        'hothor.se',
        'hotkeys.com',
        'hotloans.ru',
        'hotshoppymac.com',
        'hotsocialz.com',
        'hotxnights.info',
        'houdom.net',
        'house.sieraddns.com',
        'housediz.com',
        'housekuba.org',
        'housemilan.ru',
        'houseofgaga.ru',
        'houseofrose.com',
        'houston-vikings.com',
        'hoverboard360.at',
        'hoverboard360.de',
        'hoverboard360.es',
        'hoverboard360.nl',
        'hoverboard360.se',
        'hoverboardforsaledirect.com',
        'howlongdoestizanidinestayinyoursystem.blogspot.com',
        'howmuchdoestizanidinecost.blogspot.com',
        'howopen.ru',
        'howtoclean.club',
        'howtowhitenteethfast.xyz',
        'hoztorg-opt.ru',
        'hplaserjetpdriver8y.pen.io',
        'hptwaakw.blog.fc2.com',
        'hreade.com',
        'hscsscotland.com',
        'hspline.com',
        'htmlcorner.com',
        'https-legalrc.biz',
        'hubbble.com',
        'huhn.altervista.org',
        'huimin764128.com',
        'hulfingtonpost.com',
        'hully.altervista.org',
        'humanelydrew.com',
        'humanorightswatch.org',
        'hundejo.com',
        'hunterboots.online',
        'hunthillfarmtrust.org',
        'husky-shop.cz',
        'hustoon.over-blog.com',
        'hut1.ru',
        'hvd-store.com',
        'hybrid.ru',
        'hydropump.su',
        'hyhj.info',
        'hyiphunter.org',
        'hyipmanager.in',
        'hystersister.com',
        'i-hobot.ru',
        'i-midias.net.br',
        'i-service.kz',
        'i4track.net',
        'iamsport.org',
        'ibb.com.ua',
        'iboss.com',
        'icaseclub.ru',
        'iccornacircri.cf',
        'ico.re',
        'ictizanidinehcl4mg.blogspot.com',
        'id-forex.com',
        'idc.com.ua',
        'idealtits.net',
        'ideashome.id',
        'ideawheel.com',
        'idegenvezeto.eu',
        'ideibiznesa2015.ru',
        'ideoworld.org',
        'ido3.com',
        'ie.57883.net',
        'ifirestarter.ru',
        'iflycapetown.co.za',
        'ifmo.ru',
        'igadgetsworld.com',
        'igithab.com',
        'igrovyeavtomaty777.ru',
        'igru-xbox.net',
        'iinstalll-fii1leis.jus0wil.pp.ua',
        'ikearugs.xyz',
        'iklysha.ml',
        'ikritikimou.gr',
        'ilbe.club',
        'ilikevitaly.com',
        'ilmen.net',
        'ilmexico.com',
        'iloveitaly.ru',
        'ilovevitaly.com',
        'ilovevitaly.ru',
        'ilovevitaly.xyz',
        'ilte.info',
        'imabase.com',
        'imadedinner.net',
        'imagecoolpub.com',
        'imagefinder.site',
        'imagerydatabase.com',
        'images-free.net',
        'images-graphics-pics.com',
        'images.gyffu.com',
        'imediadesk.com',
        'imfamous.info',
        'img.wallpaperstock.net',
        'imgarcade.com',
        'imgata.com',
        'imicrovision.com',
        'iminent.com',
        'imitex-plus.ru',
        'imk.com.ua',
        'immobiliaremassaro.com',
        'imperia31.ru',
        'imperiafilm.ru',
        'impisr.edunsk.ru',
        'impisr.ru',
        'import-sales.com',
        'importchinacoach-teach.com',
        'impresagaia.it',
        'inbabes.sexushost.com',
        'inboundlinks.win',
        'inboxdollars.com',
        'inclk.com',
        'incolors.club',
        'incomekey.net',
        'increasewwwtraffic.info',
        'indetiske.ya.ru',
        'indiakino.net',
        'indianmedicaltourismshop.com',
        'indiasourcemart.in',
        'indo-export.ru',
        'inet-traffic.com',
        'infazavr.ru',
        'infobabki.ru',
        'infodocsportal.com',
        'infokonkurs.ru',
        'informatiecentro.be',
        'infospot.pt',
        'infostatsvc.com',
        'infowarcraft.ru',
        'inmate-locator.us',
        'innodgfdriverhm.aircus.com',
        'inome.com.ua',
        'insider.pro',
        'insomniagamingfestival.com',
        'insta-add.pro',
        'instabid.tech',
        'insurple.com',
        'int.search.mywebsearch.com',
        'int.search.tb.ask.com',
        'integritylandscapeservices.com',
        'intelhdgraphicsgtdrive6w.metroblog.com',
        'intellekt21.ru',
        'intellektmedia.at',
        'interesnie-faktu.ru',
        'interferencer.ru',
        'interfucks.net',
        'interior-stickers.ru',
        'intermesh.net',
        'internet-apteka.ru',
        'internetartfair.com',
        'internetproviderstucson.com',
        'intervsem.ru',
        'intim-uslugi.info',
        'intimshop-fantasy.ru',
        'invest-pamm.ru',
        'investingclub.ru',
        'investmac.com',
        'investpamm.ru',
        'investsuccess.org',
        'investyb.com',
        'investzalog.ru',
        'invitefashion.com',
        'invivo.hu',
        'inzn.ru',
        'io9.com',
        'iomoio.net',
        'iopeninghours.co.uk',
        'ip-guide.com',
        'ipchicken.com',
        'iphantom.com',
        'iplogger.org',
        'iplusbit.blogspot.co.za',
        'ipostroika.ru',
        'iptool.xyz',
        'iqbazar.ru',
        'iqoption-bin.com',
        'iqoption.com',
        'iqoption.pro',
        'iqs.biz.ua',
        'iqupdatetmz.win',
        'iradiology.ru',
        'irkutsk.online-podarki.com',
        'irkutsk.zrus.org',
        'irunfar.com',
        'iscblog.info',
        'isistaylorporn.info',
        'iskalko.ru',
        'islamtoday.co.za',
        'islandminingsupply.wordpress.com',
        'isotoner.com',
        'isoveti.ru',
        'ispaniya-costa-blanca.ru',
        'istanbulit.com',
        'istizanidineacontrolledsubstance.blogspot.com',
        'istizanidineanarcoticdrug.blogspot.com',
        'istizanidineanopiate.blogspot.com',
        'istizanidinelikexanax.blogspot.com',
        'istmira.ru',
        'istock-mebel.ru',
        'istripper.com',
        'it-max.com.ua',
        'itbc.kiev.ua',
        'itch.io',
        'itis4you.com',
        'itrevolution.cf',
        'itronics.ca',
        'itsdp3.com',
        'itservicesthatworkforyou.com',
        'iusstf.org',
        'ivanovo.zrus.org',
        'ivanstroi.ru',
        'ivearchenceinflu.cf',
        'ivoiretechnocom.ci',
        'iwantedmoney.com',
        'iwantmyfreecash.com',
        'iwanttodeliver.com',
        'iweblist.info',
        'ix20.ru',
        'iyasimasennka.com',
        'izhevsk.xrus.org',
        'izhevsk.zrus.org',
        'izismile.com',
        'izoll.ru',
        'j-times.ru',
        'j33x.com',
        'jacago.com',
        'jackwolfskinoutlet.online',
        'jamiembrown.com',
        'janavibekken.no',
        'janerikholst.se',
        'janettabridal.com',
        'japan-bearings.ru',
        'japfm.com',
        'jasonpartington.com',
        'javatex.co.id',
        'javitas.info',
        'javrip.net',
        'jaxcube.info',
        'jbl-charge.info',
        'je7.us',
        'jennyfire.ru',
        'jerseychinabizwholesale.com',
        'jerseychinabizwholesale.us',
        'jerseysbizwholesalecheap.com',
        'jerseyschinabizwholesale.us',
        'jerseyssportsshop.com',
        'jerseyswholesalechinalimited.com',
        'jerseywholesalebizchina.com',
        'jerseywholesalechinabiz.com',
        'jerseywholesaleelitestore.com',
        'jestr.org',
        'jetsli.de',
        'jewelryandfiligree.com',
        'jikoman.info',
        'jillepille.com',
        'jimmychoosale.online',
        'jjbabskoe.ru',
        'jmat.cn',
        'job.icivil.ir',
        'jobmarket.com.ua',
        'joessmogtestonly.com',
        'johannesburgsingles.co.za',
        'johnrobertsoninc.com',
        'joingames.org',
        'jolic2.com',
        'jongose.ninja',
        'journalhome.com',
        'journeydownthescale.info',
        'jpcycles.com',
        'jrcigars.com',
        'jrpmakati.com',
        'juliadiets.com',
        'juliaworld.net',
        'jumptap.com',
        'junglenet-a.akamaihd.net',
        'jurajskie.info',
        'jus0wil.pp.ua',
        'justbcause.com',
        'justdating.online',
        'justkillingti.me',
        'justprofit.xyz',
        'justucalling32211123456789.tk',
        'jwss.cc',
        'kaac.ru',
        'kabbalah-red-bracelets.com',
        'kadashihotel.com',
        'kaidalibor.de',
        'kalandranis.gr',
        'kalb.ru',
        'kaliningrad.zrus.org',
        'kam-dom.ru',
        'kamagragelusa.net',
        'kamalsinha.com',
        'kambasoft.com',
        'kamen-e.ru',
        'kamorel.com',
        'kandidos.com',
        'kanimage.com',
        'karachev-city.ru',
        'karadene.com',
        'karaganda.xkaz.org',
        'kareliatobacco.ru',
        'karpun-iris.ru',
        'karting196.ru',
        'kartiniresto.com',
        'karusel-market.ru',
        'kashubadesign.ru',
        'kasino-money.pw',
        'katjimej.blog.fc2.com',
        'katushka.net',
        'kaz.kz',
        'kazan.xrus.org',
        'kazan.zrus.org',
        'kazinogames.lv',
        'kazka.ru',
        'kazrent.com',
        'kchaxton.com',
        'keenoutlet.online',
        'kemerovo.zrus.org',
        'kenaba.su',
        'kerch.site',
        'kerei.ru',
        'kerwinandcariza.com',
        'ketoanhanoi.info',
        'ketrzyn.pl',
        'keyhantercume.com',
        'keyword-suggestions.com',
        'keywordblocks.com',
        'keywordhut.com',
        'keywords-monitoring-success.com',
        'keywords-monitoring-your-success.com',
        'keywordsking.com',
        'keywordsuggest.org',
        'keywordsuggests.com',
        'keywordteam.net',
        'kfon.eu',
        'khafre.us',
        'kichenaid.ru',
        'kicknights.gq',
        'kidd.reunionwatch.com',
        'kiev.ua',
        'kihi.gdn',
        'kiinomaniak.pl',
        'kimcurlrvsms.com',
        'kino-ecran.ru',
        'kino-filmi.com',
        'kino-fun.ru',
        'kino-key.info',
        'kino-rating.ru',
        'kino2018.club',
        'kinobaks.com',
        'kinobest.pl',
        'kinocccp.net',
        'kinoduh.ru',
        'kinofak.net',
        'kinoflux.net',
        'kinogolos.ru',
        'kinogonew.ru',
        'kinohall.ru',
        'kinohit1.ru',
        'kinomaniatv.pl',
        'kinoplen.ru',
        'kinopolet.net',
        'kinosed.net',
        'kinostorm.net',
        'kinotorka.ru',
        'kiprinform.com',
        'kirov.zrus.org',
        'kiskinhouse.com',
        'kit-opt.ru',
        'kiwe-analytics.com',
        'kiwi237au.tk',
        'kladrus.ru',
        'kleine-titten.biz',
        'klejonka.info',
        'kletkimehan.ru',
        'klikbonus.com',
        'kliksaya.com',
        'klin3952.ru',
        'klosetkitten.com',
        'klumba55.ru',
        'kmd-pto.ru',
        'kmgamex.cf',
        'kndxbkdx.bloger.index.hr',
        'knigonosha.net',
        'knogg.net',
        'knowsitall.info',
        'knowyournextmove.com',
        'kochanelli.com',
        'kol-energo.ru',
        'koleso24.com.ua',
        'kollekcioner.ru',
        'kollesa.ru',
        'kolotiloff.ru',
        'komp-pomosch.ru',
        'komputernaya-pomosh-moscow.ru',
        'komputers-best.ru',
        'kongoultry.net',
        'kongruan.com',
        'konkursov.net',
        'konkursowo-24.pl',
        'konoplisemena.com',
        'konpax.com',
        'konteiner24.com',
        'konturkrasoty.ru',
        'koopilka.com',
        'kopihijau.info',
        'koptims.tiu.ru',
        'koral.se',
        'koronirealestate.gr',
        'kosmetyki.tm.pl',
        'kosova.de',
        'kostenlos-sexvideos.com',
        'kostenloser-sex.com',
        'kosynka-games.ru',
        'kotaku.com',
        'kountrylife.com',
        'koversite.info',
        'kovesszucs.atw.hu',
        'kozhniebolezni.com',
        'krafte.ru',
        'kraljeva-sutjeska.com',
        'krasivoe-hd.com',
        'krasivoe-hd.net',
        'krasivye-devushki.net',
        'krasnodar-avtolombards.ru',
        'krasnodar.ru',
        'krasnodar.xrus.org',
        'krasnodar.zrus.org',
        'krassh.ru',
        'krasula.pp.ua',
        'kreativperlen.ch',
        'kredit-blog.ru',
        'kredit-pod-zalog-krasnodar.ru',
        'kriokomora.info',
        'krynica.info',
        'ks1234.com',
        'ktotut.net',
        'ku6.com',
        'kumuk.info',
        'kung-fu-ru.com',
        'kupit-adenu.ru',
        'kurbappeal.info',
        'kursy-ege.ru',
        'kurwa.win',
        'kustanay.kz',
        'kutikomi.net',
        'kuzinsp.ru',
        'kvartir-remont.biz',
        'kvartira-sutochno.com',
        'kvartiry-remont.ucoz.ru',
        'kw21.org',
        'kwzf.net',
        'la-fa.ru',
        'laapp.com',
        'labafydjxa.su',
        'labelwater.se',
        'labplus.ru',
        'labvis.host.sk',
        'lacasamorett.com',
        'lacave.ntic.fr',
        'lacloop.info',
        'ladov.ru',
        'laexotic.com',
        'lafourmiliaire.com',
        'lafriore.ru',
        'lakomka.com.ua',
        'lampokrat.ws',
        'lanadelreyfans.us',
        'lanasshop.ru',
        'lancheck.net',
        'landmania.ru',
        'landoftracking.com',
        'landreferat.ru',
        'landscaping.center',
        'languagecode.com',
        'lankarns.com',
        'laparfumotec.com',
        'lapitec.eu',
        'laptop-4-less.com',
        'laptoper.net',
        'larchik.net',
        'larger.io',
        'larose.jb2c.me',
        'larutti.ru',
        'lashstudia.ru',
        'lasvegaslockandsafe.com',
        'laudit.ru',
        'laulini.soclog.se',
        'law-check-eight.xyz',
        'law-check-nine.xyz',
        'law-check-seven.xyz',
        'law-check-two.xyz',
        'lawyers.cafe',
        'lawyersinfo.org',
        'laxdrills.com',
        'layola.biz.tc',
        'lazy-z.com',
        'lazymanyoga.com',
        'ldrtrack.com',
        'le-clos-des-alouettes.com',
        'leadn.pl',
        'leadwayau.com',
        'leboard.ru',
        'lechenie-gemorroya.com',
        'lechtaczka.net',
        'ledis.top',
        'ledpolice.ru',
        'leftofcentrist.com',
        'legalrc.biz',
        'legionalpha.com',
        'lego4x4.ru',
        'lenvred.org',
        'lernur.net',
        'lerporn.info',
        'lesbian.xyz',
        'lescinq.com',
        'letmacwork.world',
        'letmacworkfaster.site',
        'letmacworkfaster.world',
        'letolove.ru',
        'letsart.ru',
        'letslowbefast.site',
        'letslowbefast.today',
        'letsrepair.in',
        'letto.by',
        'levaquin750mg.blogspot.com',
        'lexaprogeneric.link',
        'lezbiyanki.net',
        'lflash.ru',
        'li-er.ru',
        'libertybilisim.com',
        'lida-ru.com',
        'lider-zhaluzi.kiev.ua',
        'lietaer.com',
        'life-instyle.com',
        'life.biz.ua',
        'lifebyleese.com',
        'lifehacĸer.com',
        'light.ifmo.ru',
        'lightinghomes.net',
        'lignofix.ua',
        'likesdesign.com',
        'likesuccess.com',
        'likrot.com',
        'liky.co.ua',
        'limads.men',
        'limtu.ifmo.ru',
        'lincolntheatre.com',
        'linerdrilling.com',
        'lineshops.biz',
        'link.ac',
        'linkarena.com',
        'linkbolic.com',
        'linkbuddies.com',
        'linkbux.ru',
        'linkdebrideur.xyz',
        'linkpulse.com',
        'linkredirect.biz',
        'linkrr.com',
        'linksharingt.com',
        'linkwithin.com',
        'lion.bolegapakistan.com',
        'lion.conboy.us',
        'lion.misba.us',
        'lion.playtap.us',
        'lion.snapmap.us',
        'liquimondo.com',
        'liran-locks.com',
        'lirunet.ru',
        'lisque.batcave.net',
        'littleberry.ru',
        'littlecity.ch',
        'littlesunraiser.com',
        'liupis.com',
        'live-sexcam.tk',
        'live-sexchat.ru',
        'livefixer.com',
        'liveinternet.ro',
        'liveinternet.ru',
        'livejasmin.com',
        'liver-chintai.org',
        'liverpool.gsofootball.com',
        'liveshoppersmac.com',
        'livetsomudvekslingstudent.bloggersdelight.dk',
        'liveu.infoteka.hu',
        'livingcanarias.com',
        'livingroomdecor.info',
        'lizace.com',
        'ljusihus.se',
        'lkbennettoutlet.online',
        'lkbennettstore.online',
        'llastbuy.ru',
        'lmrauction.com',
        'loadingpages.me',
        'loadopia.com',
        'lob.com.ru',
        'localflirtbuddies.com',
        'localmatchbook.com',
        'locatellicorretor.com.br',
        'locationdesaison.com',
        'lockerz.com',
        'locksmith.jp',
        'lodki-pvh.dp.ua',
        'loftdigital.eu',
        'loginduepunti.it',
        'lol-smurfs.com',
        'lollypopgaming.com',
        'lolnex.us',
        'lomb.co',
        'lombardfinder.ru',
        'lombia.co',
        'lombia.com',
        'lomza.info',
        'lonely-mature.com',
        'lonerangergames.com',
        'long-beach-air-conditioning.com',
        'longadventure.com',
        'longgreen.info',
        'lookingglassemb.com',
        'losangeles-ads.com',
        'lost-alpha.ru',
        'lostfilm-online.ru',
        'lotto6888.com',
        'lottospring.com',
        'louboutinbooties.xyz',
        'louboutinreplica.pw',
        'louboutinreplica.xyz',
        'louboutinshoes.xyz',
        'louisvuittonoutletstore.net',
        'lovasszovetseg.hu',
        'love-baby.cz',
        'lovelycraftyhome.com',
        'lovi-moment.com.ua',
        'low-format.ru',
        'lowephotos.info',
        'lsex.xyz',
        'lsp-awak-perikanan.com',
        'ltvperf.com',
        'lubetube.com',
        'luciddiagnostics.in',
        'luckyday.world',
        'luckyshop.net.ua',
        'lulea-auktionsverk.se',
        'lumb.co',
        'lutherstable.org',
        'luxmagazine.cf',
        'luxup.ru',
        'lyngdalhudterapi.no',
        'lyrics.home-task.com',
        'lyrster.com',
        'm-google.xyz',
        'm.b00kmarks.com',
        'm0r0zk0-krava.ru',
        'm1media.net',
        'm292.info',
        'm3gadownload.pl',
        'm4ever.net',
        'm5home.ru',
        'mabdoola.blogspot.com',
        'mac-shield.com',
        'macdamaged.space',
        'macdamaged.tech',
        'macfix.life',
        'machicon-akihabara.info',
        'mackeeper-center.club',
        'mackeeper-land-672695126.us-east-1.elb.amazonaws.com',
        'macnewtech.com',
        'macotool.com',
        'macresource.co.uk',
        'macrotek.ru',
        'mactechinfo.info',
        'madot.onlinewebshop.net',
        'mafa-free.com',
        'mafcards.ru',
        'magazin-pics.ru',
        'magazintiande.ru',
        'magda-gadalka.ru',
        'magento-crew.net',
        'magicalfind-a.akamaihd.net',
        'magicdiet.gq',
        'magicplayer-s.acestream.net',
        'maglid.ru',
        'magnetic-bracelets.ru',
        'magnetpress.sk',
        'mahnwachen-helfen.info',
        'mail.allnews24.in',
        'mailemedicinals.com',
        'mainlinehobby.net',
        'maju.bluesalt.co',
        'make-money-online.com',
        'makedo.ru',
        'makemoneyonline.com',
        'makis.nu',
        'maladot.com',
        'mall.uk',
        'malls.com',
        'malwareremovalcenter.com',
        'mamasuper.prom.ua',
        'managerpak204.weebly.com',
        'manifestation.betteroffers.review',
        'manipulyator-peterburg.ru',
        'mansparskats.com',
        'mantramusic.ru',
        'manualterap.roleforum.ru',
        'manuscript.su',
        'manve.info',
        'manyresultshub-a.akamaihd.net',
        'mapquestz.us',
        'maranbrinfo.com.br',
        'mararoom.ru',
        'marblestyle.ru',
        'marcogrup.com',
        'marcoislandvacations.net',
        'marcowebonyodziezowe.pl',
        'maridan.com.ua',
        'marinetraffic.com',
        'marketingtechniques.info',
        'marketingvici.com',
        'marketland.ml',
        'markjaybeefractal.com',
        'marktforschung-stuttgart.com',
        'marmitaco.cat',
        'marmotstore.online',
        'marsgatan.com',
        'martlinker.com',
        'marwer.info',
        'maslenka.kz',
        'massage-info.nl',
        'masserect.com',
        'master-muznachas.ru',
        'masterseek.com',
        'mastershef.club',
        'masthopehomes.com',
        'masturbate.co.uk',
        'matb3aa.com',
        'matchpal-a.akamaihd.net',
        'matematikus.info',
        'mathgym.com.au',
        'matrixalchemy.com',
        'matsdale.com',
        'mature.free-websites.com',
        'max-eclat.men',
        'max-p.men',
        'maximilitary.ru',
        'maximpartnerspr.com',
        'maxthon.com',
        'maxxtor.eu',
        'mazda-roadsters.com',
        'mb140.ru',
        'mbiologi.ru',
        'mcadamssupplyco.com',
        'mcar.in.ua',
        'mcnamaratech.com',
        'me-ke.com',
        'mearns-tractors.co.uk',
        'mebel-alait.ru',
        'mebel-vstroika.ru',
        'mebelcomplekt.ru',
        'mebeldekor.com.ua',
        'meble-bogart.info',
        'mecash.ru',
        'meccadumps.net',
        'med-zdorovie.com.ua',
        'medanestesia.ru',
        'meddesk.ru',
        'medi-fitt.hu',
        'mediaoffers.click',
        'mediawhirl.net',
        'medicinacom.ru',
        'medicine-4u.org',
        'medicines-choice.com',
        'medicovi.com',
        'medictube.ru',
        'medispainstitute.com.au',
        'medizinreisen.de',
        'medkletki.ru',
        'medkritika.ru',
        'medmajor.ru',
        'medosmotr-ufa.ru',
        'meds-online24.com',
        'medtherapy.ru',
        'meduza-consult.ru',
        'meendo-free-traffic.ga',
        'meetingrainstorm.bid',
        'meetlocalchicks.com',
        'mega-bony-2017.pl',
        'mega-bony2017.pl',
        'mega-polis.biz.ua',
        'megaapteka.ru',
        'megahdporno.net',
        'megaindex.ru',
        'megakino.net',
        'megavolt.net.ua',
        'meget.co.za',
        'meltwater.com',
        'member-quiz.com',
        'members.ghanaweb.com',
        'memberty.com',
        'menetie.ru',
        'menhealed.net',
        'mensandals.xyz',
        'menstennisforums.com',
        'mere.host.sk',
        'merryhouse.co.uk',
        'mesbuta.info',
        'message-warning.net',
        'mesto-x.com',
        'metabar.ru',
        'metalonly.info',
        'metarip.ru',
        'metascephe.com',
        'metaxalonevstizanidine.blogspot.com',
        'methodsmarketing.com',
        'mex-annushka.ru',
        'mexicosleevegastrectomy.com',
        'mexicotravelnet.com',
        'mezaruk.info',
        'mhi-systems.ru',
        'mhtr.be',
        'micasainvest.com',
        'michaelkorsoutlet.store',
        'michaelkorsoutletstore.net',
        'michaelkorssaleoutletonline.net',
        'microsearch.ru',
        'microsoftportal.net',
        'microstatic.pl',
        'middlerush-a.akamaihd.net',
        'midst.eu',
        'mielec.pl',
        'migente.com',
        'mikozstop.com',
        'mikrobiologies.ru',
        'mil-stak.com',
        'milblueprint.com',
        'militarysale.pro',
        'millionare.com',
        'mindbox.co.za',
        'mindeyegames.com',
        'minecraft-neo.ru',
        'minecraft-rus.org',
        'minegam.com',
        'minharevisao.com',
        'mini.7zap.com',
        'miniads.ca',
        'minneapoliscopiers.com',
        'minyetki.ru',
        'mir-betting.ru',
        'mir-business-24.ru',
        'mir-limuzinov.ru',
        'mirmedinfo.ru',
        'mirobuvi.com.ua',
        'mirtorrent.net',
        'mirzonru.net',
        'misandesign.se',
        'missclub.info',
        'missis.top',
        'missvietnam.org',
        'misswell.net',
        'mister-shop.com',
        'misterjtbarbers.com',
        'mistr-x.org',
        'mitrasound.ru',
        'mixed-wrestling.ru',
        'mixtapetorrent.com',
        'mixx.com',
        'mjchamonix.org',
        'mlf.hordo.win',
        'mlvc4zzw.space',
        'mmgq.ru',
        'mmofreegames.online',
        'mmog-play.ru',
        'mmoguider.ru',
        'mmostrike.ru',
        'mmstat.com',
        'mncrftpcs.com',
        'mnogabukaff.net',
        'mnogolok.info',
        'mobifunapp.weebly.com',
        'mobile.ok.ru',
        'mobilemedia.md',
        'mobilierland.com',
        'mobioffertrck.com',
        'mobot.site',
        'mobplayer.net',
        'mobplayer.ru',
        'mobsfun.net',
        'mobstarr.com',
        'mockupui.com',
        'modabutik.ru',
        'modenamebel.ru',
        'moesen-ficken.com',
        'moesonce.com',
        'moetomnenie.com',
        'moi-glazki.ru',
        'moivestiy.biz',
        'mojaocena.com',
        'moje-recenze.cz',
        'mojowhois.com',
        'mojpregled.com',
        'mojpreskumanie.com',
        'mokrayakiska.com',
        'mole.pluto.ro',
        'monarchfind-a.akamaihd.net',
        'monarhs.info',
        'monclerboots.xyz',
        'monclercheap.xyz',
        'monclercoats.xyz',
        'monclerjacketsoutlet.pw',
        'monclerjacketsoutlet.win',
        'moncleronline.xyz',
        'moncleroutletonline.pw',
        'moncleroutletonline.win',
        'moncleroutletonline.xyz',
        'monclervests.xyz',
        'monetizationking.net',
        'monetizer.com-01.site',
        'money-every-day.com',
        'money-for-placing-articles.com',
        'moneymaster.ru',
        'moneyteam24.com',
        'moneytop.ru',
        'moneyviking-a.akamaihd.net',
        'monitorwebsitespeed.com',
        'monsterdivx.com',
        'monsterdivx.tv',
        'montazhnic.ru',
        'monthlywinners.com',
        'montredemarque.nl',
        'moomi-daeri.com',
        'more-letom.ru',
        'morefastermac.trade',
        'morepoweronmac.trade',
        'morf.snn.gr',
        'morlat.altervista.org',
        'morocco-nomad-excursions.com',
        'moroccosurfadventures.com',
        'moscow-clining.ru',
        'moscow-region.ru',
        'moscow.online-podarki.com',
        'moscow.xrus.org',
        'mosdverka.ru',
        'moskva.nodup.ru',
        'mosrif.ru',
        'mossmesi.com',
        'most-kerch.org',
        'most.gov.iq',
        'mostantikor.ru',
        'motherboard.vice.com',
        'mototsikl.org',
        'mountainstream.ms',
        'mouselink.co',
        'moviemail-online.co.uk',
        'movies-in-theaters.net',
        'moviezbonkerssk.cf',
        'mowser.com',
        'moxo.com',
        'moyakuhnia.ru',
        'moyaterapiya.ru',
        'moz.com',
        'mp3downloadhq.com',
        'mp3films.ru',
        'mp3ringtone.info',
        'mrbitsandbytes.com',
        'mrcsa.com.au',
        'mrinsidesales.com',
        'mriyadh.com',
        'mrlmedia.net',
        'mrmoneymustache.com',
        'mrsdalloways.com',
        'mrwhite.biz',
        'msfsaar.de',
        'msk-diplomat.com',
        'msk.afora.ru',
        'mttwtrack.com',
        'mturkcontent.com',
        'muabancantho.info',
        'mug-na-chas-moscow.ru',
        'muizre.ru',
        'mulberryoutletonlineeu.com',
        'multgo.ru',
        'mundoaberrante.com',
        'muschisexbilder.com',
        'musezone.ru',
        'musezone.su',
        'musflashtv.com',
        'music.utrolive.ru',
        'music7s.me',
        'musicas.baixar-musicas-gratis.com',
        'musicdaddy.net',
        'musicktab.com',
        'musicspire.online',
        'musicstock.me',
        'musicvidz.ru',
        'musirc.com',
        'mustat.com',
        'mustwineblog.com',
        'muz-baza.net',
        'muz-shoes.ru',
        'muz-tracker.net',
        'muzaporn.com',
        'muznachas-service.ru',
        'muztops.ru',
        'mvpicton.co.uk',
        'mwtpludn.review',
        'mxgetcode.com',
        'my-bc.ru',
        'my-big-family.com',
        'my-cash-bot.co',
        'myanyone.net',
        'mybinaryoptionsrobot.com',
        'myblogregistercm.tk',
        'mycaf.it',
        'mycouponizemac.com',
        'mydeathspace.com',
        'mydirtyhobby.com',
        'mydirtystuff.com',
        'mydownloadengine.com',
        'mydownlodablefiles.com',
        'myfreecams.com',
        'myfreemp3.eu',
        'myfreetutorials.com',
        'myftpupload.com',
        'mygameplus.com',
        'mygameplus.ru',
        'myghillie.info',
        'myhealthcare.com',
        'myhitmp3.club',
        'myindospace.com',
        'myiptest.com',
        'mykings.pw',
        'mylesosibirsk.ru',
        'mylida.org',
        'myliveblog.ru',
        'mymobilemoneypages.com',
        'myonigroup.com',
        'myonlinepayday.co',
        'myperiod.club',
        'mypets.by',
        'myplaycity.com',
        'mypornfree.ru',
        'myprintscreen.com',
        'myseoconsultant.com',
        'mysexpics.ru',
        'myshopmatemac.com',
        'mystats.xyz',
        'mywallpaper.top',
        'myxdate.info',
        'myyour.eu',
        'na-telefon.biz',
        'na15.ru',
        'nac-bearings.ru',
        'nacap.ru',
        'nagdak.ru',
        'nailsimg.com',
        'naj-filmy24.pl',
        'najaden.no',
        'nakozhe.com',
        'nalogovyy-kodeks.ru',
        'nalogovyykodeks.ru',
        'namenectar.com',
        'napalm51.nut.cc',
        'naperehresti.info',
        'naphukete.ru',
        'narco24.me',
        'nardulan.com',
        'narkologiya-belgorod.ru',
        'narkologiya-orel.ru',
        'narkologiya-penza.ru',
        'narkologiya-peterburg.ru',
        'narkologiya-voronezh.ru',
        'narosty.com',
        'narutonaruto.ru',
        'nash-krym.info',
        'nastroyke.net',
        'nastydollars.com',
        'nate.com',
        'nationalbreakdown.com',
        'naturalbreakthroughsresearch.com',
        'naughtyconnect.com',
        'naval.jislaaik.com',
        'navalwiki.info',
        'nbsproject.ru',
        'needtosellmyhousefast.com',
        'negociosdasha.com',
        'negral.pluto.ro',
        'nelc.edu.eg',
        'neobux-bg.info',
        'neodownload.webcam',
        'nero-us.com',
        'nerudlogistik.ru',
        'net-profits.xyz',
        'net-radar.com',
        'netallergy.ru',
        'netanalytics.xyz',
        'netcheckcdn.xyz',
        'netfacet.net',
        'netoil.no',
        'netpics.org',
        'netvouz.com',
        'networkad.net',
        'networkcheck.xyz',
        'nevansk.ru',
        'new-apps.ru',
        'new-post.tk',
        'new7ob.com',
        'newhairstylesformen2014.com',
        'news-readers.ru',
        'newsperuse.com',
        'newstaffadsshop.club',
        'newstraveller.ru',
        'newstudio.tv',
        'newtechspb.ru',
        'newyorkhotelsmotels.info',
        'nextbackgroundcheck.gq',
        'nextconseil.com',
        'nextlnk12.com',
        'nextrent-crimea.ru',
        'nfljerseys.online',
        'nfljerseyscheapbiz.us',
        'nfljerseyscheapchinabiz.com',
        'nfljerseysforsalewholesaler.com',
        'nfvsz.com',
        'ngps1.ru',
        'nhl09.ru',
        'nhl17coins.exblog.jp',
        'nhl17coinsforps3.gratisblog.biz',
        'nibbler.silktide.com',
        'nicefloor.co.uk',
        'nicovideo.jp',
        'nightvision746.weebly.com',
        'nikhilbahl.com',
        'niki-mlt.ru',
        'nikitabuch.com',
        'nikitsyringedrivelg.pen.io',
        'nikkiewart.ru',
        'ningessaybe.me',
        'nippon-bearings.ru',
        'niroo.info',
        'njkmznnb.ru',
        'njpalletremoval.com',
        'nl.netlog.com',
        'nlfjjunb5.ru',
        'nmrk.ru',
        'no-rx.info',
        'noclegonline.info',
        'nodding-passion.tk',
        'nodup.ru',
        'nofreezingmac.click',
        'nofreezingmac.work',
        'nonews.co',
        'nootrino.com',
        'nordstar.pro',
        'nordvpn.com',
        'normalegal.ru',
        'northfacestore.online',
        'norththeface.store',
        'nosecret.com.ua',
        'notaria-desalas.com',
        'notasprensa.info',
        'notebook-pro.ru',
        'notfastfood.ru',
        'nottyu.xyz',
        'noumeda.com',
        'novatech.vn',
        'november-lax.com',
        'novgorod.xrus.org',
        'novodigs.com',
        'novosibirsk.xrus.org',
        'novosti-hi-tech.ru',
        'nowtorrents.com',
        'npoet.ru',
        'nrjmobile.fr',
        'nrv.co.za',
        'nsatc.net',
        'ntic.fr',
        'nucia.biz.ly',
        'nudepatch.net',
        'nudo.ca',
        'nufaq.com',
        'nuit-artisanale.com',
        'nuker.com',
        'nullrefer.com',
        'nuup.info',
        'nvformula.ru',
        'nvssf.com',
        'nyfinance.ml',
        'nzfilecloud.weebly.com',
        'o-dachnik.ru',
        'o-o-11-o-o.com',
        'o-o-6-o-o.com',
        'o-o-6-o-o.ru',
        'o-o-8-o-o.com',
        'o-o-8-o-o.ru',
        'o.light.d0t.ru',
        'o00.in',
        'o333o.com',
        'oakleyglassesonline.us',
        'oakridgemo.com',
        'oballergiya.ru',
        'obesidadealgarve.com',
        'obnal.org',
        'obsessionphrases.com',
        'obuv-kupit.ru',
        'ochistka-stokov.ru',
        'oconto.ru',
        'oda.as',
        'oddamzadarmo.eu',
        'odesproperty.com',
        'odoratus.net',
        'odywpjtw.bloger.index.hr',
        'oecnhs.info',
        'of-ireland.info',
        'offer.camp',
        'offer.wpsecurity.website',
        'offergroup.info',
        'offers.bycontext.com',
        'offf.info',
        'office-windows.ru',
        'office2web.com',
        'officedocuments.net',
        'offside2.5v.pl',
        'offtime.ru',
        'offtopic.biz',
        'ohmyrings.com',
        'oil-td.ru',
        'ok-ua.info',
        'ok.ru',
        'okayimage.com',
        'okel.co',
        'oklogistic.ru',
        'okmusic.jp',
        'okonich.com.ua',
        'okout.ru',
        'okroshki.ru',
        'oktube.ru',
        'okuos.com',
        'old-rock.com',
        'olgacvetmet.com',
        'olvanto.ru',
        'olympescort.com',
        'omoikiri-japan.ru',
        'omsk.xrus.org',
        'onclickpredictiv.com',
        'onclkads.com',
        'one-gear.com',
        'oneclickfiles.com',
        'onefilms.net',
        'onemactrckr.com',
        'onemantrip.com',
        'oneminutesite.it',
        'onescreen.cc',
        'oneshotdate.com',
        'onetravelguides.com',
        'onlainbesplatno.ru',
        'onlinadverts.com',
        'online-hd.pl',
        'online-hit.info',
        'online-podarki.com',
        'online-sbank.ru',
        'online-templatestore.com',
        'online-x.ru',
        'online.ktc45.ru',
        'online247.ml',
        'online7777.com',
        'onlinebay.ru',
        'onlinedomains.ru',
        'onlinefilmz.net',
        'onlineku.com',
        'onlinemeetingnow.com',
        'onlinemegax.com',
        'onlineporno.site',
        'onlineserialy.ru',
        'onlineslotmaschine.com',
        'onlinetvseries.me',
        'onlinewritingjobs17.blogspot.ru',
        'onload.pw',
        'onlyforemont.ru',
        'onlythegames.com',
        'onlywoman.org',
        'ons-add.men',
        'onstrapon.purplesphere.in',
        'ontargetseo.us',
        'ooo-gotovie.ru',
        'ooo-olni.ru',
        'ooomeru.ru',
        'oops-cinema.ru',
        'open-odyssey.org',
        'openfrost.com',
        'openfrost.net',
        'openlibrary.org',
        'openmediasoft.com',
        'openmultipleurl.com',
        'openstat.com',
        'opinionreelle.com',
        'ops.picscout.com',
        'optibuymac.com',
        'optikremont.ru',
        'optitrade24.com',
        'optom-deshevo.ru',
        'oralsexfilme.net',
        'oranga.host.sk',
        'ordernorxx.com',
        'orel-reshka.net',
        'oren-cats.ru',
        'orenburg-gsm.ru',
        'orgasmus-virtual.com',
        'orhonit.com',
        'origin-my.ru',
        'orion-code-access.net',
        'orion-v.com',
        'ororodnik.goodbb.ru',
        'orsonet.ru',
        'osagonline.ru',
        'osb.se11.ru',
        'osnova3.ru',
        'osoznanie-narkotikam.net',
        'ossmalta.com',
        'ostroike.org',
        'ostrovtaxi.ru',
        'otbelivanie-zubov.com',
        'ourtherapy.ru',
        'ourville.info',
        'outclicks.net',
        'outpersonals.com',
        'outrageousdeal-a.akamaihd.net',
        'outshop.ru',
        'ovirus.ru',
        'owathemes.com',
        'ownshop.cf',
        'ownshop.win',
        'owohho.com',
        'oxford-book.com.ua',
        'oxotl.com',
        'oynat.info',
        'oyster-green.com',
        'oz-offers.com',
        'ozas.net',
        'ozoz.it',
        'p-business.ru',
        'paceform.com',
        'pacificair.com',
        'paclitor.com',
        'page2rss.com',
        'pagesense.com',
        'paidonlinesites.com',
        'paleohub.info',
        'palocco.it',
        'palvira.com.ua',
        'pammik.ru',
        'panamaforbeginners.com',
        'panchro.co.uk',
        'panchro.xyz',
        'pandarastore.top',
        'panouri-solare-acoperis.com',
        'paparazzistudios.com.au',
        'papasdelivery.ru',
        'paperwritingservice17.blogspot.ru',
        'paphoselectricianandplumber.com',
        'par-fallen.ga',
        'paradontozanet.ru',
        'parajumpersjakkesalgnorge.info',
        'parajumpersoutlet.online',
        'parajumpersstore.online',
        'paramountmarble.co.uk',
        'parfusale.se',
        'park.above.com',
        'parlament.biz',
        'partner-cdn.men',
        'partner-high.men',
        'partner-host.men',
        'partner-pop.men',
        'partner-print.men',
        'partner-stop.men',
        'partner-trustworthy.men',
        'partnerads.men',
        'partnerline.men',
        'partners-ship.pro',
        'partnersafe.men',
        'partnerworkroom.men',
        'partybunny.ru',
        'pastaleads.com',
        'pateaswing.com',
        'pathwhelp.org',
        'patol01.pw',
        'patterntrader-en.com',
        'pattersonsweb.com',
        'pavlodar.xkaz.org',
        'pay2me.pl',
        'paydayloanslocal.com',
        'paydayonlinecom.com',
        'pb-dv.ru',
        'pc-services.ru',
        'pc-test.net',
        'pc-virus-d0l92j2.pw',
        'pc4download.co',
        'pcads.ru',
        'pcboa.se',
        'pcgroup.com.uy',
        'pcimforum.com',
        'pdamods.ru',
        'pdn-4.com',
        'pdns.cz',
        'pdns.download',
        'pearlisland.ru',
        'pechikamini.ru',
        'peekyou.com',
        'pekori.to',
        'pelfind.me',
        'pendelprognos.se',
        'penisvergrotendepillennl.ovh',
        'pensplan.com',
        'pensplan4u.com',
        'pepperstyle.ru',
        'percin.biz.ly',
        'perfection-pleasure.ru',
        'perfectpracticeweb.com',
        'perl.dp.ua',
        'perm-profnastil.ru',
        'perm.xrus.org',
        'perosan.com',
        'perso.wanadoo.es',
        'pestomou.info',
        'petedrummond.com',
        'petitions.whitehouse.gov',
        'petrovka-online.com',
        'petsblogroll.com',
        'peugeot-club.org',
        'pewit.pw',
        'pflexads.com',
        'pharmacyincity.com',
        'phobia.us',
        'phormchina.com',
        'photo-clip.ru',
        'photo.houseofgaga.ru',
        'photochki.com',
        'photokitchendesign.com',
        'photorepair.ru',
        'photostudiolightings.com',
        'phpdevops.com',
        'phuketscreen.com',
        'physfunc.ru',
        'pic2fly.com',
        'piccdata.com',
        'piccshare.com',
        'picphotos.net',
        'picquery.com',
        'pics-group.com',
        'picscout.com',
        'picsearch.com',
        'picsfair.com',
        'picsforkeywordsuggestion.com',
        'picture-group.com',
        'pictures-and-images.com',
        'pictures-and-images.net',
        'picturesfrom.com',
        'picturesify.com',
        'picturesmania.com',
        'pierrehardysale.online',
        'pigrafix.at',
        'pihl.se',
        'pijoto.net',
        'pila.pl',
        'pills24h.com',
        'pillscheap24h.com',
        'pinkduck.ga',
        'pinsdaddy.com',
        'pinstake.com',
        'pintattoos.com',
        'pinwallpaper.top',
        'pinwallpaper.xyz',
        'pio.polytopesexempt.com',
        'pipki.r.acdnpro.com',
        'piratecams.com',
        'pirateday.ru',
        'pisanieprac.info',
        'piski.top',
        'piter.xrus.org',
        'piulatte.cz',
        'piuminiita.com',
        'pix-hd.com',
        'pix24x7.com',
        'pixell.club',
        'pixelrz.com',
        'pixgood.com',
        'pixshark.com',
        'pizda.lol',
        'pizdopletka.club',
        'pizza-imperia.com',
        'pizza-tycoon.com',
        'pk-pomosch.ru',
        'pk-services.ru',
        'pkr1hand.com',
        'pl-top.pl',
        'pl-vouchers.com',
        'pl.aasoldes.fr',
        'pl.id-forex.com',
        'pladform.ru',
        'plaff-go.ru',
        'plastgran.com',
        'plastgranar.nu',
        'plastjulgranar.se',
        'plastweb.ru',
        'platesauto.com',
        'platezhka.net',
        'platinumdeals.gr',
        'play-movie.pl',
        'play-mp3.com',
        'play.leadzupc.com',
        'playboyfiles.xblog.in',
        'playlott.com',
        'playmsn.com',
        'playtap.us',
        'pliks.pl',
        'ploenjitmedia.azurewebsites.net',
        'plohaya-kreditnaya-istoriya.ru',
        'plusnetwork.com',
        'pobeiranie.pl',
        'pochemychka.net',
        'pochtovyi-index.ru',
        'podshipniki-nsk.ru',
        'podshipniki-ntn.ru',
        'poem-paying.gq',
        'poems.com.ua',
        'poffet.net',
        'pogodnyyeavarii.gq',
        'pogosh.com',
        'pogruztehnik.ru',
        'poisk-zakona.ru',
        'pojdelo.weebly.com',
        'pokemon-go-play.online',
        'pokemongooo.ml',
        'pokerniydom.ru',
        'polcin.de',
        'polybuild.ru',
        'polytopesexempt.com',
        'pomoc-drogowa.cba.pl',
        'pons-presse.com',
        'pontiacsolstice.info',
        'pony-business.com',
        'popads.net',
        'popander.mobi',
        'popcash.net',
        'popmarker.com',
        'poppen-nw.net',
        'popserve.adscpm.net',
        'poptool.net',
        'popugauka.ru',
        'popugaychiki.com',
        'popunder.net',
        'popunder.ru',
        'popup-fdm.xyz',
        'popup-hgd.xyz',
        'popup-jdh.xyz',
        'popup.matchmaker.com',
        'poquoson.org',
        'porn-w.org',
        'porn555.com',
        'porndairy.in',
        'porngalleries.top',
        'pornhub-forum.ga',
        'pornhub-ru.com',
        'pornhubforum.tk',
        'pornmania.pl',
        'porno-chaman.info',
        'porno-dojki.net',
        'porno-play.net',
        'porno-raskazy.ru',
        'porno-transsexuals.ru',
        'porno-video-chati.ru',
        'porno.simple-image.com.ua',
        'pornoblood.com',
        'pornobrazzers.biz',
        'pornodojd.ru',
        'pornoelita.info',
        'pornofiljmi.com',
        'pornoforadult.com',
        'pornogig.com',
        'pornohd1080.online',
        'pornokajf.com',
        'pornoklad.net',
        'pornoklad.ru',
        'pornokorol.com',
        'pornolook.net',
        'pornonik.com',
        'pornophoto.xyz',
        'pornosee.info',
        'pornosemki.info',
        'pornoslive.net',
        'pornosmola.info',
        'pornotubexxx.name',
        'pornpost.in',
        'pornstartits.xblog.in',
        'pornzone.tv',
        'porodasobak.net',
        'portadd.men',
        'portal-eu.ru',
        'portnoff.od.ua',
        'porto.abuilder.net',
        'portside.cc',
        'portside.xyz',
        'poshiv-chehol.ru',
        'posible.net',
        'positive2b.ru',
        'pospr.waw.pl',
        'postclass.com',
        'potoideas.us',
        'potolokelekor.ru',
        'powc.r.ca.d.sendibm2.com',
        'powenlite24.ru',
        'powitania.pl',
        'pozdravleniya-c.ru',
        'pozdrawleniya.com',
        'pozdrawleniya.ru',
        'pozvonim.com',
        'pp-budpostach.com.ua',
        'pr-ten.de',
        'pr0fit-b0x.com',
        'praisong.net',
        'pravoholding.ru',
        'prchecker.info',
        'predmety.in.ua',
        'predominant-invent.tk',
        'prefersurvey.net',
        'preg.marketingvici.com',
        'pregnant.guru',
        'preparevideosafesystem4unow.site',
        'preparevideosafesystem4unow.space',
        'presleycollectibles.com',
        'pretty-mart.com',
        'preventheadacheguide.info',
        'priceg.com',
        'pricheskaonline.ru',
        'pricheski-video.com',
        'primedice.com',
        'princeadvantagesales.com',
        'printdirectforless.com',
        'printie.com',
        'printingpeach.com',
        'priora-2.com',
        'priscilarodrigues.com.br',
        'privacyassistant.net',
        'privat-girl.net',
        'privatamateure.com',
        'privatbank46.ru',
        'privatefx-in.ru',
        'privatefx.all4invest.info',
        'privatov-zapisi.ru',
        'privetsochi.ru',
        'privhosting.com',
        'prize44.com',
        'prizeestates.cricket',
        'prizefestival.mobi',
        'prizesbook.online',
        'prizestohandle.club',
        'prlog.ru',
        'pro-okis.ru',
        'pro-tec.kz',
        'prod2016.com',
        'prodess.ru',
        'producm.ru',
        'productarium.com',
        'produkto.net',
        'prodvigator.ua',
        'proekt-gaz.ru',
        'proekt-mos.ru',
        'professionaldieselcare.com',
        'professionalwritingservices15.blogspot.ru',
        'profit-opportunity.com',
        'profitfx.online',
        'profitkode.com',
        'profitsport.club',
        'profitwithalex.info',
        'profolan.pl',
        'proftests.net',
        'progonrumarket.ru',
        'progress-upakovka.ru',
        'prohoster.info',
        'prointer.net.ua',
        'projectforte.ru',
        'projefrio.com.br',
        'prokotov.com',
        'prom23.ru',
        'promalp-universal.ru',
        'prombudpostach.com.ua',
        'promgirldresses.xyz',
        'promodj.com',
        'promoforum.ru',
        'promoheads.com',
        'promover.org',
        'pron.pro',
        'pronekut.com',
        'pronorm.fr',
        'proposal-engine.com',
        'propranolol40mg.blogspot.com',
        'proprostatit.com',
        'prosmibank.ru',
        'prospekt-st.ru',
        'prosperent.com',
        'prostitutki-almata.org',
        'prostitutki-astana.org',
        'prostitutki-belgoroda.org',
        'prostitutki-kharkova.org',
        'prostitutki-kiev.org',
        'prostitutki-novgoroda.org',
        'prostitutki-odessa.org',
        'prostitutki-rostova.org',
        'prostitutki-tolyatti.org',
        'prostitutki-tyumeni.org',
        'prostitutki-yaroslavlya.org',
        'proxyelite.biz',
        'proxyradar.com',
        'prpops.com',
        'psa48.ru',
        'pskcijdc.bloger.index.hr',
        'psoriasis-file.trade',
        'pssucai.info',
        'pst2017.onlinewebshop.net',
        'psvita.ru',
        'ptr.ruvds.com',
        'pts163.ru',
        'pufip.com',
        'pukaporn.com',
        'pulse33.ru',
        'pulseonclick.com',
        'purchasepillsnorx.com',
        'purplesphere.in',
        'purplestats.com',
        'puserving.com',
        'push-ad.com',
        'pushdata.sendpulse.com',
        'pussyfleet.com',
        'pussysaga.com',
        'puteshestvennik.com',
        'putevka24.ru',
        'putitin.me',
        'puzo2arbuza.ru',
        'puzzleweb.ru',
        'pwwysydh.com',
        'pxhdwsm.com',
        'py100.ru',
        'pyramidlitho.webs.com',
        'pyrodesigns.com.au',
        'q-moto.ru',
        'qcstrtvt.bloger.index.hr',
        'qexyfu.bugs3.com',
        'qitt.ru',
        'qld10000.net',
        'qor360.com',
        'qpypcx.com',
        'quality-traffic.com',
        'qualitymarketzone.com',
        'quangcaons.com',
        'quebec-bin.com',
        'queerspace.com',
        'quelle.ru',
        'questionmarque.ch',
        'quick-offer.com',
        'quick-seeker.com',
        'quickbuck.com',
        'quickcashlimited.com',
        'quickchange.cc',
        'quickloanbank.com',
        'quit-smoking.ga',
        'quizzitch.net',
        'qwarckoine.com',
        'qwesa.ru',
        'r-control.ru',
        'r-e-f-e-r-e-r.com',
        'raavidesigns.com',
        'rabot.host.sk',
        'rabotaetvse.ru',
        'rada.ru',
        'radiodigital.co',
        'radiogambling.com',
        'ragecash.com',
        'rainbowice.ru',
        'raisedseo.com',
        'randalljhoward.com',
        'randki-sex.com',
        'rangjued.com',
        'rank-checker.online',
        'rankexperience.com',
        'rankia.com',
        'ranking2017.ga',
        'rankingchart.de',
        'rankings-analytics.com',
        'ranksays.com',
        'rankscanner.com',
        'ranksignals.com',
        'ranksonic.com',
        'ranksonic.info',
        'ranksonic.org',
        'rapevideosmovies.com',
        'rapidgator-porn.ga',
        'rapidokbrain.com',
        'rapidsites.pro',
        'raschtextil.com.ua',
        'rasteniya-vs-zombi.ru',
        'ratemodels.net',
        'razamicroelectronics.com',
        'razorweb-a.akamaihd.net',
        'razyboard.com',
        'rcb101.ru',
        'rcpmda.ikan1080.xyz',
        'real-time-analytics.com',
        'realitykings.com',
        'realizmobi.com',
        'realmonte.net',
        'realnye-otzyvy.info',
        'realresultslist.com',
        'realting-moscow.ru',
        'realtytimes.com',
        'rebelmouse.com',
        'rebrand.ly',
        'rebuildermedical.com',
        'recinziireale.com',
        'recipedays.com',
        'recipedays.ru',
        'reckonstat.info',
        'recordpage-a.akamaihd.net',
        'redbottomheels.xyz',
        'redhotfreebies.co.uk',
        'redirect.trafficreceiver.club',
        'redirectingat.com',
        'redirectme.net',
        'redirlock.com',
        'rednise.com',
        'reelheroes.net',
        'reeyanaturopathy.com',
        'refads.pro',
        'referencemoi.com',
        'refererx.com',
        'refudiatethissarah.info',
        'regdefense.com',
        'regionshop.biz',
        'registratciya-v-moskve.ru',
        'registrationdomainsite.com',
        'registry-clean-up.net',
        'registry-cleaner.net',
        'registrydomainservices.com',
        'registrysweeper.com',
        'reimageplus.com',
        'reining.lovasszovetseg.hu',
        'reklama-i-rabota.ru',
        'reklama1.ru',
        'reklamuss.ru',
        'relax.ru',
        'remedyotc.com',
        'remmling.de',
        'remont-comp-pomosh.ru',
        'remont-fridge-tv.ru',
        'remont-komputerov-notebook.ru',
        'remont-mobile-phones.ru',
        'remont-ustanovka-tehniki.ru',
        'remontbiz.ru',
        'remontgruzovik.ru',
        'remontvsamare.su',
        'remorcicomerciale.ro',
        'remote-dba.de',
        'remybutler.fr',
        'renecaovilla.online',
        'renecaovillasale.online',
        'renewablewealth.com',
        'rennlist.com',
        'rentaremotecomputer.com',
        'rentehno.ru',
        'rep-am.com',
        'repeatlogo.co.uk',
        'replica-watch.ru',
        'replicaclub.ru',
        'replicalouboutin.xyz',
        'resant.ru',
        'research.ifmo.ru',
        'resellerclub.com',
        'responsinator.com',
        'responsive-test.net',
        'respublica-otel.ru',
        'restaurantlescampi.com',
        'restorator-msk.ru',
        'resultshub-a.akamaihd.net',
        'retailwith.com',
        'rethinkwasteni.info',
        'retreatia.com',
        'reversing.cc',
        'revistaindustria.com',
        'reward-survey.net',
        'rewardit.com',
        'rewardpoll.com',
        'reyel1985.webnode.fr',
        'rezeptiblud.ru',
        'rfd-split.hr',
        'rff-cfal.info',
        'rfid-locker.co',
        'rialp.getenjoyment.net',
        'ribieiendom.no',
        'ric.info',
        'richinvestmonitor.com',
        'ricorsogiustizia.org',
        'riders.ro',
        'rightenergysolutions.com.au',
        'rimedia.org',
        'ring4rhino.com',
        'ringporno.com',
        'ringtonepartner.com',
        'rique.host.sk',
        'risparmiocasa.bz.it',
        'ritlweb.com',
        'rixpix.ru',
        'rn-to-bsn.com',
        'robot-forex.biz',
        'rocketchange.ru',
        'rockingclicks.com',
        'rockma.se',
        'rockprogblog.com',
        'rogervivierforsale.com',
        'roleforum.ru',
        'roll123.com',
        'roma-kukareku.livejournal.com',
        'rome2rio.com',
        'roofers.org.uk',
        'rootandroid.org',
        'ros-ctm.ru',
        'rosbalt.com.ua',
        'rospromtest.ru',
        'rossanasaavedra.net',
        'rossmark.ru',
        'rostov.xrus.org',
        'royal-betting.net',
        'royal-investments.net',
        'royalads.net',
        'royalcar-ufa.ru',
        'royalvegascasino.com',
        'rozalli.com',
        'roznica.com.ua',
        'rp9.ru',
        'ru-dety.ru',
        'rubanners.com',
        'rubbed.us',
        'ruclicks.com',
        'rucrypt.com',
        'ruex.org.ua',
        'ruf777.com',
        'rukino.org',
        'rumamba.com',
        'running-line.ru',
        'runofilms.ru',
        'runstocks.com',
        'runtnc.net',
        'rus-teh.narod.ru',
        'ruscoininvest.company',
        'ruscopybook.com',
        'rusenvironmental.net',
        'rusexy.xyz',
        'rusoft-zone.ru',
        'ruspdd.com',
        'rusprostitute.com',
        'russia-tao.ru',
        'russia-today-video.ru',
        'russintv.fr',
        'russkie-gorki.ru',
        'russkoe-zdorovie.ru',
        'rustic-quiver.win',
        'rvtv.ru',
        'rvzr-a.akamaihd.net',
        'rybalka-opt.ru',
        'ryetaw.com',
        's-iwantyou.com',
        's.lollypopgaming.com',
        's8-nowy-wygraj.comli.com',
        'sa-live.com',
        'sa-rewards.co.za',
        'sabaapress.com',
        'sabizonline.com',
        'sack.net',
        'sad-torg.com.ua',
        'sadaholding.com',
        'saddiechoua.com',
        'sady-urala.ru',
        'safe-app.net',
        'saitevpatorii.com',
        'sajatvelemeny.com',
        'sakhboard.ru',
        'sale-japan.com',
        'saletool.ru',
        'salmonfishingsacramentoriver.com',
        'salutmontreal.com',
        'samara.rosfirm.ru',
        'sammlungfotos.online',
        'sammyweaver.com',
        'samo-soznanie.ru',
        'samoiedo.it',
        'samolet.fr',
        'sampleletters.net',
        'sanatorrii.ru',
        'sandhillsonline.com',
        'saneitconsulting.com',
        'saneyes.com',
        'sanidumps.com',
        'sanjosestartups.com',
        'sankt-peterburg.nodup.ru',
        'santasgift.ml',
        'santechnik.jimdo.com',
        'sanyuprojects.com',
        'sarafangel.ru',
        'saratov.xrus.org',
        'sardinie.us',
        'sarf3omlat.com',
        'sarm.tk',
        'sashagreyblog.ga',
        'satellite.maps.ilovevitaly.com',
        'saugatuck.com',
        'savefrom.com',
        'saveindex.xyz',
        'savememoney.co.za',
        'savetubevideo.com',
        'savingsslider-a.akamaihd.net',
        'sawin.beth.webd.pl',
        'sax-sex.com',
        'sayyoethe.blogspot.co.za',
        'sbdl.no',
        'sbetodiodnye-lampy.ru',
        'sbornik-zakonov.ru',
        'sbprabooks.com',
        'sbricur.com',
        'sbt-aqua.ru',
        'sbtdesign.co.uk',
        'sbwealthsolutions.ca',
        'sc-specialhost.com',
        'scalerite.co.za',
        'scanmarine.info',
        'scanmyphones.com',
        'scanner-alex.top',
        'scanner-alexa.top',
        'scanner-andrew.top',
        'scanner-barak.top',
        'scanner-brian.top',
        'scanner-don.top',
        'scanner-donald.top',
        'scanner-elena.top',
        'scanner-fred.top',
        'scanner-george.top',
        'scanner-irvin.top',
        'scanner-ivan.top',
        'scanner-jack.top',
        'scanner-jane.top',
        'scanner-jess.top',
        'scanner-jessica.top',
        'scanner-john.top',
        'scanner-josh.top',
        'scanner-julia.top',
        'scanner-julianna.top',
        'scanner-margo.top',
        'scanner-mark.top',
        'scanner-marwin.top',
        'scanner-mary.top',
        'scanner-nelson.top',
        'scanner-olga.top',
        'scanner-viktor.top',
        'scanner-walt.top',
        'scanner-walter.top',
        'scanner-willy.top',
        'scansafe.net',
        'scanspyware.net',
        'scat.porn',
        'scenarii-1-sentyabrya.uroki.org.ua',
        'scenicmissouri.us',
        'schlampen-treffen.com',
        'school-diplomat.ru',
        'schoolfiles.net',
        'scmor.ilxc.cc',
        'scoopquest.com',
        'scopich.com',
        'score-ads.men',
        'scottbywater.com',
        'scrapy.org',
        'screentoolkit.com',
        'scripted.com',
        'scrnet.biz.ua',
        'sdelai-prosto.ru',
        'sdelatmebel.ru',
        'sdi-pme.com',
        'sdrescher.net',
        'sdsjweb.com',
        'se-welding.ru',
        'se.bnt-team.com',
        'seadragonherbery.com',
        'seansonline24.pl',
        'search-error.com',
        'search-goo.com',
        'search.1and1.com',
        'search.alot.com',
        'search.pch.com',
        'search.xtconnect.com',
        'searchaddis.com',
        'searchencrypt.com',
        'searchengineranker.email',
        'searchimage.co',
        'searchimpression.com',
        'searchinquire.com',
        'searchinterneat-a.akamaihd.net',
        'searchkut.com',
        'searchlock.com',
        'searchmywindow-a.akamaihd.net',
        'searchtooknow-a.akamaihd.net',
        'searchwebknow-a.akamaihd.net',
        'seasaltwithfood.com',
        'seasonvar.ru',
        'seccioncontrabajo.com',
        'secret.xn--oogle-wmc.com',
        'secretscook.ru',
        'security60-e.com',
        'securityallianceservices.com',
        'see-your-website-here.com',
        'seeingmeerkat.com',
        'seemoreresultshu-a.akamaihd.net',
        'seeresultshub-a.akamaihd.net',
        'segol.tv',
        'sei80.com',
        'seinterface.com',
        'seksotur.ru',
        'selectads.men',
        'sell-fb-group-here.com',
        'semalt.com',
        'semaltmedia.com',
        'seminarygeorgia59.ga',
        'seminarykansas904.ml',
        'semp.net',
        'semprofile.com',
        'semrush.com',
        'sendearnings.com',
        'senger.atspace.co.uk',
        'seo-2-0.com',
        'seo-platform.com',
        'seo-smm.kz',
        'seo-tools-optimizing.com',
        'seo-traffic-ranking.info',
        'seoanalyses.com',
        'seoboxes.com',
        'seocdvig.ru',
        'seocheckupx.com',
        'seocheki.net',
        'seoexperimenty.ru',
        'seofied.com',
        'seofirmreviewsus.info',
        'seogadget.ru',
        'seoheap.com',
        'seoholding.com',
        'seojokes.net',
        'seokicks.de',
        'seomarketings.online',
        'seonetwizard.com',
        'seoprofiler.com',
        'seorank.info',
        'seorankinglinks.com',
        'seorankinglinks.us',
        'seorankinglinks.xyz',
        'seorussian.ru',
        'seotoolsagency.com',
        'serdcenebolit.com',
        'sergiorossistore.online',
        'serialsway.ucoz.ru',
        'serptehnika.ru',
        'servethis.com',
        'service-core.ru',
        'service.adtech.fr',
        'service.adtech.us',
        'servicecenter.co.ua',
        'serving.adbetclickin.pink',
        'servingnotice.com',
        'servisural.ru',
        'serw.clicksor.com',
        'seryeznie-znakomstva.ru',
        'sethrollins.net',
        'sevendays.com.ua',
        'sevenstars7.com',
        'sex-dating.co',
        'sex-foto.pw',
        'sex-pr.net',
        'sex-sex-sex5.com',
        'sex-tracker.com',
        'sex-tracker.de',
        'sex-watch.com',
        'sex.hotblog.top',
        'sexad.net',
        'sexblog.pw',
        'sexcamamateurchat.com',
        'sexflirtbook.com',
        'sexkontakte-seite.com',
        'sexkontakteao.info',
        'sexkrasivo.net',
        'sexobzor.info',
        'sexpartygirls.net',
        'sexphoto.site',
        'sexreliz.com',
        'sexsaoy.com',
        'sexsearch.com',
        'sexstream.pl',
        'sextracker.be',
        'sextracker.com',
        'sextracker.de',
        'sexvideo-sex.com',
        'sexvporno.ru',
        'sexy-pings.com',
        'sexy-screen-savers.com',
        'sexyali.com',
        'sexystrippe.info',
        'sexyteens.hol.es',
        'sexytrend.ru',
        'sfd-chess.ru',
        'sfj-ror.no',
        'shakhtar-doneck.ru',
        'shama-rc.net',
        'share-buttons-for-free.com',
        'sharebutton.net',
        'sharebutton.org',
        'sharebutton.to',
        'shariki-zuma-lines.ru',
        'sharpchallenge.com',
        'shell-pmr.ru',
        'shemale-sex.net',
        'shemalegalls.blogporn.in',
        'sherlock.se',
        'shijian.ac.cn',
        'shiksabd.com',
        'shillyourcoins.com',
        'shinikiev.com.ua',
        'ship-marvel.co.ua',
        'shisha-swag.de',
        'shitmovs.com',
        'shivafurnishings.com',
        'shlyahten.ru',
        'shmetall.com.ua',
        'shodanhq.com',
        'shoesonlinebuy.cn',
        'shoesonlinebuy.xyz',
        'shohanb.com',
        'shop-electron.ru',
        'shop.acim.org',
        'shop.xz618.com',
        'shopcheermakeup.info',
        'shoplvlv.us',
        'shopperifymac.com',
        'shoppingjequiti.com.br',
        'shoppingmiracles.co.uk',
        'shoppytoolmac.com',
        'shopsellcardsdumps.com',
        'shopvilleroyboch.com.ua',
        'shopwme.ru',
        'shtaketniki.kz',
        'shtaketniki.ru',
        'shtora66.ru',
        'shymkent.xkaz.org',
        'si-unique.com',
        'sibdevice.ru',
        'sibecoprom.ru',
        'sibtest.ru',
        'sibvitr.ru',
        'sicfor.bcu.cc',
        'sideeffectsoftizanidine.blogspot.com',
        'sientalyric.co',
        'sierraapps.com',
        'sigmund-freud.co.uk',
        'signal03.ru',
        'signoredom.com',
        'signx.info',
        'siha.de',
        'sildenafil-tadalafil.info',
        'sildenafilcitratemed.com',
        'silktide.com',
        'silverage.ru',
        'silvercash.com',
        'silvermature.net',
        'sim-service.net',
        'similardeals.net',
        'simon3.ru',
        'simple-image.com.ua',
        'simple-share-buttons.com',
        'simplepooltips.com',
        'simply.net',
        'simpoed.ufop.br',
        'sims-sims.ru',
        'simul.co',
        'sindragosa.comxa.com',
        'sinel.info',
        'sinestesia.host.sk',
        'sisiynas.ru',
        'sispe.com.br',
        'site-analyzer.com',
        'site-auditor.online',
        'site-speed-check.site',
        'site-speed-checker.site',
        'site.ru',
        'site3.free-share-buttons.com',
        'site5.com',
        'siteaero.com',
        'sitebeam.net',
        'siteexpress.co.il',
        'siteheart.net',
        'siteimprove.com',
        'siteonomy.com',
        'siteripz.net',
        'sitevaluation.com',
        'sitevaluation.org',
        'sitevalued.com',
        'sitiz.club',
        'sitopreferito.it',
        'sivs.ru',
        'sixcooler.de',
        'sizeplus.work',
        'sk.golden-praga.ru',
        'skachat-besplatno-obrazcy.ru',
        'skanninge.se',
        'skatestick.bid',
        'skincrate.net',
        'sklad-24.ru',
        'skladvaz.ru',
        'skuteczna-dieta.co.pl',
        'skutecznetabletkinaporostwlosow.pl',
        'sky-mine.ru',
        'skylta.com',
        'skytraf.xyz',
        'skyway24.ru',
        'slavia.info',
        'slavic-magic.ru',
        'slavkokacunko.de',
        'slayerlife.com',
        'sledstvie-veli.net',
        'slim.sellany.ru',
        'slimcdn.com',
        'slkrm.ru',
        'slomm.ru',
        'slonechka.ru',
        'slowmac.tech',
        'slowmacfaster.trade',
        'sluganarodu.ru',
        'slujbauborki.ru',
        'slutloadlive.com',
        'smailik.org',
        'small-game.com',
        'small-games.biz',
        'smallseotools.com',
        'smart-balancewheel.com',
        'smart-scripts.com',
        'smartadserver.com',
        'smartbalanceworld.com',
        'smartpet.ru',
        'smartshoppymac.com',
        'smichovbike.cz',
        'smokewithrabbits.com',
        'sms2x2.ru',
        'smsactivator.ru',
        'smstraf.ru',
        'sneakyboy.com',
        'snip.to',
        'snip.tw',
        'snjack.info',
        'snjatie-geroinovoy-lomki.ru',
        'snomer1.ru',
        'snow.nvr163.com',
        'snowplanes.com',
        'snsdeainavi.info',
        'snts.shell-pmr.ru',
        'snworks.com',
        'snyatie-lomki-v-stacionare.ru',
        'soaksoak.ru',
        'sobecjvuwa.com.ru',
        'soblaznu.net',
        'soc-econom-problems.ru',
        'soc-proof.su',
        'socas.pluto.ro',
        'social-button.xyz',
        'social-buttons.com',
        'social-buttons.xyz',
        'social-fun.ru',
        'social-s-ggg.xyz',
        'social-s-hhh.xyz',
        'social-s-iii.xyz',
        'social-search.me',
        'social-vestnik.ru',
        'socialbookmarksubmission.org',
        'socialbutton.xyz',
        'socialbuttons.xyz',
        'socialmadesimple.com',
        'socialmediasuggest.com',
        'socialmonkee.com',
        'socialseet.ru',
        'socialtrade.biz',
        'sockshare.net',
        'soda.media',
        'sodexo.com',
        'sofit-dmd.ru',
        'soft-program.com',
        'soft-terminal.ru',
        'soft1.ru',
        'softlinesolutions.me',
        'softomix.com',
        'softomix.net',
        'softonicads.com',
        'softtor.com',
        'softwaretrend.net',
        'softxaker.ru',
        'soheavyblog.com',
        'sohoindia.net',
        'solicita.info',
        'solitaire-game.ru',
        'solmarket.by',
        'solnplast.ru',
        'solution4u.com',
        'sonata-arctica.wz.cz',
        'songoo.wz.cz',
        'songplanet.ru',
        'sonnikforme.ru',
        'sophang8.com',
        'sortthemesitesby.com',
        'sosdepotdebilan.com',
        'soserfis.com',
        'sotkal.lark.ru',
        'soundfrost.org',
        'souvenir.cc',
        'souvenirua.com',
        'sovetogorod.ru',
        'soviet-portal.do.am',
        'sovinsteel.ru',
        'spacash.com',
        'space-worry.ml',
        'space4update.pw',
        'space4updating.win',
        'spaceshipad.com',
        'spammen.de',
        'spamnuker.com',
        'spasswelt.net',
        'spasswelt.xyz',
        'spb-plitka.ru',
        'spb.afora.ru',
        'spb.ru',
        'spbchampionat.ru',
        'special-porn.com',
        'specialfinanceoffers.com',
        'speechfoodie.com',
        'speedup-my.site',
        'spidtest.org',
        'spidtest.space',
        'spin2016.cf',
        'spinnerco.ca',
        'spitfiremusic.com',
        'splendorsearch-a.akamaihd.net',
        'sport-video-obzor.ru',
        'sport7777.net',
        'sportbetfair.com',
        'sports-supplements.us',
        'spravka-medosmotr.ru',
        'spravka130.ru',
        'sprttrack.com',
        'sps-shop.com',
        'sptslmtrafms.com',
        'spy-app.info',
        'spy-sts.com',
        'spyfu.com',
        'spylog.com',
        'spymac.net',
        'spywarebegone.com',
        'spywareit.com',
        'spywarenuker.com',
        'spywarespy.com',
        'squidoo.com',
        'sr-rekneskap.no',
        'srdrvp.com',
        'srecorder.com',
        'srgwebmail.nl',
        'sribno.net',
        'sstroy44.ru',
        'stackthatbucks.com',
        'staff.prairiesouth.ca',
        'stair.registrydomainservices.com',
        'stairliftsarea.com',
        'stairliftstrue.com',
        'stal-rulon.ru',
        'standardchartered-forex.com',
        'stanthonyscatholicchurch.org',
        'star61.de',
        'stardevine.com',
        'stariy-baku.com',
        'starpages.net',
        'start.myplaycity.com',
        'startufa.ru',
        'startwp.org',
        'starwars.wikia.com',
        'stathat.com',
        'staticfs.host',
        'statistici.ro',
        'statoutlook.info',
        'stats-collector.org',
        'stats-public.grammarly.io',
        'statustroll.com',
        'stauga.altervista.org',
        'staynplay.net',
        'steame.ru',
        'steelmaster.lv',
        'stefanbakosab.se',
        'sterva.cc',
        'stevemonsen.com',
        'stickers-market.ru',
        'stillmiracle.com',
        'stjamesschool.info',
        'stmassage.ru',
        'stockquotes.wooeb.com',
        'stockspmb.info',
        'stoki.ru',
        'stop-gepatit.te.ua',
        'store-rx.com',
        'storehouse.ua',
        'stpicks.com',
        'stpolice.com',
        'strag-invest.ru',
        'strana-krasoty.ru',
        'strana-solnca.ru',
        'strangeduckfilms.com',
        'streetfire.net',
        'streetfooduncovered.com',
        'streha-metalko.si',
        'stretchingabuckblog.com',
        'stretchmate.net',
        'strfls.com',
        'strigkaomsk.ru',
        'stroicol.net',
        'stroilka.info',
        'stroimajor.ru',
        'stroiminsk.com',
        'stroiminsk.org',
        'stromerrealty.com',
        'strongholdsb.ru',
        'strongsignal-a.akamaihd.net',
        'stroy-portal22.ru',
        'stroydetali.ru',
        'stroyhelp-dv.ru',
        'stroymonolit.su',
        'stroyplus.ru',
        'strv.se',
        'studiofaca.com',
        'stuff-about-money.com',
        'styro.ru',
        'success-seo.com',
        'suchenindeutschland.com',
        'sudexpert66.ru',
        'sugarkun.com',
        'suggest-keywords.com',
        'sugvant.ru',
        'suhanpacktech.com',
        'sukarame.net',
        'sukirgenk.dvrlists.com',
        'summerlinhomes411.info',
        'sumo.com',
        'sundrugstore.com',
        'superfish.com',
        'superiends.org',
        'superinterstitial.com',
        'superkanpo.com',
        'superlist.biz',
        'supermama.top',
        'supermesta.ru',
        'supernew.org',
        'superoboi.com.ua',
        'supers.com.ua',
        'superstats.com',
        'supervesti.ru',
        'support.nopeas.sk',
        'suralink.com',
        'surcentro.com',
        'sureone.pro',
        'surfbuyermac.com',
        'surffoundation.nl',
        'surflinksmedical.com',
        'surgut.zrus.org',
        'surintech.ac.th',
        'survival.betteroffers.review',
        'susanholtphotography.com',
        'svarbit.com',
        'svarkagid.com',
        'svbur.ru',
        'svetlotorg.ru',
        'svetodiodoff.ru',
        'svnuppsalaorebro.se',
        'svolze.com',
        'svtrd.com',
        'swagbucks.com',
        'sweepstakes.rewardit.com',
        'swimpool.ca',
        'swinger-mobil.net',
        'swingerseiten.com',
        'swinginwithme.ru',
        'swinon.site',
        'swiped.su',
        'swsociety.se',
        'sygraem.com',
        'symbaloo.com',
        'symphonyintegratedhealthcare.com',
        'syvertsen-da.no',
        'szamponrevita.pl',
        'szucs.ru',
        't-bygg.com',
        't3chtonic.com',
        'taaaak.com',
        'tabakur77.com',
        'tabletkinaodchudzanie.com.pl',
        'taboola.com',
        'tacbelarus.ru',
        'tagil.zrus.org',
        'taihouse.ru',
        'takeflyte.com',
        'takeprofitsystem.com',
        'takethatad.com',
        'tako3.com',
        'talant-factory.ru',
        'tam-gde-more.ru',
        'tampabaywatch.org',
        'tandvardshuset.net',
        'tanieaukcje.com.pl',
        'taqplayer.info',
        'taqywu51.soup.io',
        'tarad.com',
        'taraz.xkaz.org',
        'tasteidea.com',
        'tastyfoodideas.com',
        'tattomedia.com',
        'tattoo33.ru',
        'tattooha.com',
        'tattooreligion.ru',
        'taxi-v-eisk.ru',
        'taximytishi.ru',
        'td-33.ru',
        'td-l-market.ru',
        'tds-advert005.info',
        'tdsing.ru',
        'teastory.co',
        'tech4master.com',
        'techart24.com',
        'technika-remont.ru',
        'technopellet.gr',
        'tecspb.ru',
        'tedxrj.com',
        'tedy.su',
        'teenbbw.yopoint.in',
        'teesdaleflyballclub.co.uk',
        'teguh.info',
        'tehngr.ru',
        'telefonsex-ohne0900.net',
        'telefonsexi.com',
        'telefonsexkostenlos.tk',
        'telefonsexsofort.tk',
        'telegraf.by',
        'telegramdownload10.com',
        'telemetryverification.net',
        'telesvoboda.ru',
        'telsis.com',
        'template-kid.com',
        'templates.franklinfire.co',
        'templates.radiodigital.co',
        'tengohydar.tk',
        'terraclicks.com',
        'terrafootwear.us',
        'teslathemes.com',
        'testingads.pro',
        'tetracsaudi.com',
        'texbaza.by',
        'textads.men',
        'tfxiq.com',
        'tgtclick.com',
        'thaisamkok.com',
        'the-torrent-tracker.blogspot.com',
        'the-trader.net',
        'the-usa-games.blogspot.com',
        'theallgirlarcade.com',
        'theautoprofit.ml',
        'thebestweightlosspills.ovh',
        'thebitcoincode.com',
        'thebluenoodle.com',
        'thebluffs.com',
        'thecoolimages.net',
        'thecoral.com.br',
        'thecounter.com',
        'thedownloadfreeonlinegames.blogspot.com',
        'thedownloadfromwarez.blogspot.com',
        'thefarmergame.com',
        'thefds.net',
        'thegameriders.com',
        'thegamerznetwork.com',
        'thegioixekhach.com',
        'theguardlan.com',
        'theheroes.ru',
        'thejournal.ru',
        'thelottosecrets.com',
        'themeforest.net',
        'themestotal.com',
        'thenetinfo.com',
        'thenews-today.info',
        'theplacetoupdating.pw',
        'thepokertimer.com',
        'theprofitsmaker.net',
        'thesmartsearch.net',
        'thetardistimes.ovh',
        'thetattoohut.com',
        'thetoiletpaper.com',
        'thewebsitetemplate.info',
        'thewomenlife.com',
        'thfox.com',
        'thiegs.reco.ws',
        'thin.me.pn',
        'thruport.com',
        'tiandeural.ru',
        'ticketsys.inetwd.com',
        'tiens2010.ru',
        'tilido.com',
        'timdreby.com',
        'time-japan.ru',
        'timeallnews.ru',
        'timecrimea.ru',
        'timer4web.com',
        'timetorelax.biz',
        'timhost.ru',
        'titan-ads.life',
        'titan-cloud.life',
        'titangel-vietnam.com',
        'titelhelden.eu',
        'titslove.yopoint.in',
        'tizanidine4mg.blogspot.com',
        'tizanidine4mgprice.blogspot.com',
        'tizanidine4mgstreetprice.blogspot.com',
        'tizanidine4mgstreetvalue.blogspot.com',
        'tizanidine4mgtablets.blogspot.com',
        'tizanidine4mguses.blogspot.com',
        'tizanidine6mg.blogspot.com',
        'tizanidineandcipro.blogspot.com',
        'tizanidineandgabapentin.blogspot.com',
        'tizanidineandhydrocodone.blogspot.com',
        'tizanidinecapsules.blogspot.com',
        'tizanidinecost.blogspot.com',
        'tizanidinedosage.blogspot.com',
        'tizanidinedosageforsleep.blogspot.com',
        'tizanidinedruginteractions.blogspot.com',
        'tizanidinedrugtest.blogspot.com',
        'tizanidineduringpregnancy.blogspot.com',
        'tizanidinefibromyalgia.blogspot.com',
        'tizanidineformigraines.blogspot.com',
        'tizanidineforopiatewithdrawal.blogspot.com',
        'tizanidinehcl2mg.blogspot.com',
        'tizanidinehcl2mgsideeffects.blogspot.com',
        'tizanidinehcl2mgtablet.blogspot.com',
        'tizanidinehcl4mgisitanarcotic.blogspot.com',
        'tizanidinehcl4mgtab.blogspot.com',
        'tizanidinehcl4mgtabinfo.blogspot.com',
        'tizanidinehcl4mgtablet.blogspot.com',
        'tizanidinehclsideeffects.blogspot.com',
        'tizanidinehydrochloride2mg.blogspot.com',
        'tizanidinehydrochloride4mgstreetvalue.blogspot.com',
        'tizanidineinfo.blogspot.com',
        'tizanidineingredients.blogspot.com',
        'tizanidineinteractions.blogspot.com',
        'tizanidinemusclerelaxant.blogspot.com',
        'tizanidinenarcotic.blogspot.com',
        'tizanidineonline.blogspot.com',
        'tizanidineoral.blogspot.com',
        'tizanidineorflexeril.blogspot.com',
        'tizanidinepain.blogspot.com',
        'tizanidinepills.blogspot.com',
        'tizanidinerecreationaluse.blogspot.com',
        'tizanidinerestlesslegsyndrome.blogspot.com',
        'tizanidineshowupondrugtest.blogspot.com',
        'tizanidinesideeffects.blogspot.com',
        'tizanidinesideeffectsweightloss.blogspot.com',
        'tizanidinesleepaid.blogspot.com',
        'tizanidinestreetprice.blogspot.com',
        'tizanidinestreetvalue.blogspot.com',
        'tizanidineusedfor.blogspot.com',
        'tizanidinevscyclobenzaprine.blogspot.com',
        'tizanidinevssoma.blogspot.com',
        'tizanidinevsvalium.blogspot.com',
        'tizanidinewithdrawal.blogspot.com',
        'tizanidinewithdrawalsymptoms.blogspot.com',
        'tizanidinezanaflex.blogspot.com',
        'tjkckpytpnje.com',
        'tk-assortiment.ru',
        'tkanorganizma.ru',
        'tksn.ru',
        'tmearegion26.com',
        'tmm-kurs.ru',
        'tmtrck.com',
        'tn811.us',
        'tnaionline.org',
        'tnctrx.com',
        'tobeyouday.win',
        'todohr.com',
        'toloka.hurtom.com',
        'tomatis.gospartner.com',
        'tomck.com',
        'tongkatmadura.info',
        'toolsky.com',
        'toon-families.com',
        'toondinsey.com',
        'toonfamilies.net',
        'tooplay.com',
        'tootoo.to',
        'top-deal.com.pl',
        'top-karkas.ru',
        'top-study.work',
        'top1-seo-service.com',
        'top10-way.com',
        'top10registrycleaners.com',
        'top250movies.ru',
        'topads.men',
        'topappspro.com',
        'topbestgames.com',
        'topcar-krasnodar.ru',
        'topclickguru.com',
        'topdownloads.ru',
        'topkarkas.com',
        'topmira.com',
        'topquality.cf',
        'toproadrunner5.info',
        'topshef.ru',
        'topsiteminecraft.com',
        'topsy.com',
        'topvidos.ru',
        'torontoplumbinggroup.com',
        'torrent-newgames.com',
        'torrent-to-magnet.com',
        'torrents-tracker.com',
        'torrents.cd',
        'torrnada.ru',
        'torture.ml',
        'totu.info',
        'totu.us',
        'touchmods.fr',
        'tour-line.net',
        'tourcroatia.co.uk',
        'tourismvictoria.com',
        'toursmaps.com',
        'tovaroboom.vast.ru',
        'toxicwap.com',
        'toy-shop.top',
        'toyota.7zap.com',
        'toys.erolove.in',
        'tozup.com',
        'tpu.ru',
        'tracfone.com',
        'track-rankings.online',
        'track112.site',
        'track2.shop',
        'tracklead.net',
        'trackmedia101.com',
        'tracksurf.daooda.com',
        'tracksz.co',
        'trackzapper.com',
        'tracxn.com',
        'tradedeals.biz',
        'traderzplanet.in',
        'tradgardspartner.se',
        'trafaret74.ru',
        'traffic100.com',
        'traffic2cash.org',
        'traffic2money.com',
        'trafficfactory.biz',
        'trafficgenius.xyz',
        'trafficjunky.com',
        'trafficjunky.net',
        'trafficmania.com',
        'trafficmonetize.org',
        'trafficmp.com',
        'trafficnetzwerk.de',
        'trafficreceiver.club',
        'trafficstars.com',
        'traffictrade.life',
        'traffique.net',
        'traffixer.com',
        'traffmonster.info',
        'traffpartners.com',
        'trahic.ru',
        'trahvid.com',
        'trailer.cinemaflix.website',
        'trainoffend.ml',
        'tramadolandtizanidine.blogspot.com',
        'traxdom.ru',
        'treasuretrack-a.akamaihd.net',
        'tri-slona.org',
        'trichizobswiv.agddns.net',
        'trion.od.ua',
        'tripper.de',
        'triumf-realty.ru',
        'trk-4.net',
        'trkdf.com',
        'trkur.com',
        'trubywriting.com',
        'truck-addzilla.life',
        'truck-land.life',
        'truck-rece.life',
        'trucri.me',
        'trudogolik.net',
        'truebeauty.cc',
        'truemfilelj.gq',
        'trumpetedextremes.com',
        'trustaffs.com',
        'trustedhealthtips.com',
        'trustedmaccleaner.com',
        'trustl.life',
        'try-rx.com',
        'tsan.net',
        'tsstcorpcddvdwshbbdriverfb.aircus.com',
        'tsyndicate.com',
        'ttrraacckkrr.com',
        'ttsq.fr',
        'tube8.com',
        'tubeline.biz',
        'tubeoffline.com',
        'tuberkulezanet.ru',
        'tuberkuleznik.ru',
        'tubo360.com',
        'tuckermktg.com',
        'tuckpointingmasonrysystems.com',
        'tula.howotorg.ru',
        'tula.mdverey.ru',
        'tupper-posuda.ru',
        'tupper-shop.ru',
        'turbabitload.weebly.com',
        'turbo-suslik.org',
        'turbodsp.com',
        'turist-strani.ru',
        'turizm.bz',
        'turizmus.us',
        'turkeyreport.tk',
        'turn-up-life.life',
        'turvgori.ru',
        'tv-spoty.info',
        'tvand.ru',
        'tversvet.ru',
        'tvorozhnaja-zapekanka-recept.ru',
        'tvoystartup.ru',
        'tvteleport.ru',
        'twelvevisionspartyofcolorado.com',
        'twiclub.in',
        'twincitiescarservice.com',
        'twinderbella.com',
        'twitlinks.com',
        'twittrading.com',
        'twittruth.com',
        'twodollarshows.com',
        'twojebook.pl',
        'twu.com.ua',
        'tx41tclega.ru',
        'txxx.com',
        'typer.one',
        'tytoona.com',
        'tyumen.xrus.org',
        'tzritel.tk',
        'u-cheats.ru',
        'u17795.netangels.ru',
        'u555u.info',
        'ua-company.ru',
        'ua.tc',
        'uac.net.au',
        'uamtrk.com',
        'uasb.ru',
        'ublaze.ru',
        'uchebavchehii.ru',
        'uchetunet.su',
        'uchil.net',
        'ucoz.ru',
        'ucsol.ru',
        'udayavani.com',
        'udsgame.online',
        'ufa.xrus.org',
        'uggbootsoutletsale.us',
        'uggsale.online',
        'ugguk.online',
        'ugogo.info',
        'uhdtv.website',
        'uhod-za-sobakoj.ru',
        'uhodzalijami.ru',
        'uk-zheu20.ru',
        'ukkelberg.no',
        'ukrobstep.com',
        'ukrup.com',
        'ultimateclassicrock.com',
        'ultimatesetnewfreeallsoftupgradesystems.pw',
        'ultramart.biz',
        'um-razum.ru',
        'umaseh.com',
        'umekana.ru',
        'umg-stroy.ru',
        'umityangin.net',
        'umnovocaminho.com',
        'unacittaconte.org',
        'unblocksit.es',
        'undergroundcityphoto.com',
        'underthesite.com',
        'unece.org',
        'uni.me',
        'unimodemhalfduplefw.pen.io',
        'unionmarkt.de',
        'unisexjewelry.org',
        'unitexindia.com',
        'unitygame3d.com',
        'univerfiles.com',
        'universals.com.ua',
        'unlimitdocs.net',
        'unmaroll.ya.ru',
        'unpredictable.ga',
        'unrealcommander.biz',
        'unrealcommander.com',
        'unrealcommander.org',
        'uogonline.com',
        'upproar.com',
        'uprour.com',
        'upstore.me',
        'uptime-alpha.net',
        'uptime-as.net',
        'uptime-delta.net',
        'uptime-gamma.net',
        'uptime.com',
        'uptimebot.net',
        'uptimechecker.com',
        'upupa.net',
        'ural-buldozer.ru',
        'urccvfmc.bloger.index.hr',
        'urdoot.win',
        'urengoy.pro',
        'url-img.link',
        'url2image.com',
        'urlcut.ru',
        'urldelivery.com',
        'urll.eu',
        'urlopener.blogspot.com.au',
        'urlopener.com',
        'uroffer.link',
        'uroki.net',
        'urzedowski.eu',
        'us-america.ru',
        'usacasino.com',
        'usadacha.net',
        'usbggettwku.ga',
        'usdx.us',
        'userequip.com',
        'usiad.net',
        'ussearche.cf',
        'usswrite.com',
        'ustion.ru',
        'utiblog.fr',
        'utrolive.ru',
        'uvozdeckych.info',
        'uytmaster.ru',
        'uzungil.com',
        'v-doc.co',
        'v24s.net',
        'v720hd.ru',
        'vabasa.inwtrade.com',
        'vacances-voyages.info',
        'vacuumscleaner.com',
        'vadimkravtcov.ru',
        'validccseller.com',
        'validdomain.xyz',
        'valkiria-tk.ru',
        'valmetrundan.se',
        'valoresito.com',
        'valsalud.com',
        'valuado.com',
        'valueclick.com',
        'vancleefreplica.pw',
        'vandrie-ict.nl',
        'vapeface.club',
        'vapsy.com',
        'varbergsvind.se',
        'varikoz24.com',
        'varikozdok.ru',
        'vashsvet.com',
        'vasileostrovsky-rayon.ru',
        'vavilone.com',
        'vbabule.net',
        'vclicks.net',
        'vduplo.ru',
        'vedomstvo.net',
        'veerotech.com',
        'vegan-foods.us',
        'vegascosmetics.ru',
        'vektorpress.ru',
        'vekzdorov.ru',
        'vellings.info',
        'velobikestock.com',
        'venerologiya.com',
        'venta-prom.ru',
        'ventelnos.com',
        'vepad.com',
        'vereo.eu',
        'versaut.xxx-cam.webcam',
        'vertaform.com',
        'verymes.xyz',
        'veselokloun.ru',
        'vesnatehno.com',
        'vesnatehno.ru',
        'vezuviy.su',
        'vgoloveboli.net',
        'via-energy-acquistare.com',
        'via-energy-cumpara.com',
        'via-energy-order.com',
        'via-gra.webstarts.com',
        'viagra.pp.ua',
        'viagroid.ru',
        'viandpet.com',
        'viberdownload10.com',
        'viddyoze.com',
        'video--production.com',
        'video-chat.cn',
        'video-chat.in',
        'video-chat.love',
        'video-hollywood.ru',
        'video-production.com',
        'video-woman.com',
        'videochat.bz',
        'videochat.cafe',
        'videochat.life',
        'videochat.mx',
        'videochat.ph',
        'videochat.tv.br',
        'videochat.world',
        'videochaty.ru',
        'videogamesecrets.com',
        'videojam.tv',
        'videokrik.net',
        'videooko.weebly.com',
        'videos-for-your-business.com',
        'videosbox.ru',
        'videositename.com',
        'videotuber.ru',
        'videtubs.pl',
        'viel.su',
        'vielporno.net',
        'vigrx-original.ru',
        'vikistars.com',
        'viktoria-center.ru',
        'vilingstore.net',
        'villacoloniale.com',
        'villakohlanta.nu',
        'vinsit.ru',
        'vintontech.info',
        'vinylvault.co.uk',
        'vip-dom.in',
        'vip-file.com',
        'vip-parfumeria.ru',
        'vip.51.la',
        'vip2ch.com',
        'vipms.ru',
        'vipps.com.my',
        'vipromoffers.com',
        'vipsexfinders.com',
        'vipsiterip.org',
        'virtuagirl.com',
        'visa-china.ru',
        'visa-pasport.ru',
        'visionwell.com.cn',
        'visitcambridge.org',
        'vita.com.hr',
        'vitalads.net',
        'vitanail.ru',
        'viteonlusarezzo.it',
        'vitoriacabos.com',
        'viven.host.sk',
        'vizag.kharkov.ua',
        'vizitki.net',
        'vk-mus.ru',
        'vkak.ru',
        'vkgaleria.com',
        'vkonche.com',
        'vkontaktemusic.ru',
        'vkontarkte.com',
        'vksaver-all.ru',
        'vladhistory.com',
        'vladimir.xrus.org',
        'vladimir.zrus.org',
        'vltai.com',
        'vmnmvzsmn.over-blog.com',
        'vod.com.ua',
        'vodaodessa.com',
        'voditeltrezviy.ru',
        'vodkoved.ru',
        'volgograd.xrus.org',
        'voloo.ru',
        'voloomoney.com',
        'voltrknc1.com',
        'volume-pills.biz',
        'voluumtracker1.com',
        'voluumtrk.com',
        'vonradio.com',
        'voprosotvet24.ru',
        'voronezh.xrus.org',
        'vostoktrade.info',
        'vote-up.ru',
        'vozbujdenie.com',
        'vpnhowto.info',
        'vpnmouse.com',
        'vremya.eu',
        'vriel.batcave.net',
        'vrnelectro.ru',
        'vrotike.ru',
        'vsdshnik.com',
        'vsesubwaysurfers.com',
        'vseuznaem.com',
        'vsexkontakte.net',
        'vtc.pw',
        'vucms.com',
        'vut.com.ru',
        'vvon.co.uk',
        'vvpg.ru',
        'vykup-avto-krasnodar.ru',
        'vykupavto-krasnodar.ru',
        'vysigy.su',
        'vzglyadriv.kg',
        'vzlom-na-zakaz.com',
        'vzube.com',
        'w-journal.ru',
        'w3data.co',
        'w3javascript.com',
        'w7s.ru',
        'wahicbefa31.soup.io',
        'wait3sec.org',
        'walkme.com',
        'wallpapers-best.com',
        'wallpapersdesk.info',
        'wallpapersist.com',
        'wallpaperstock.net',
        'wanker.us',
        'wapsite.me',
        'wareseeker.com',
        'warezaccess.com',
        'warezkeeper.com',
        'warning.or.kr',
        'warningwar.ru',
        'warningzscaler.heraeus.com',
        'watch-movies.ru',
        'watchdogs-2.ru',
        'watchinf.com',
        'watchmyfb.pl',
        'watchmygf.net',
        'waterpurifier.club',
        'watsonrealtycorp.com',
        'waycash.net',
        'waysbetter.cn',
        'wcb.su',
        'wdfdocando.com',
        'wdrake.com',
        'we-are-gamers.com',
        'web-betting.ru',
        'web.cvut.cz',
        'webads.co.nz',
        'webadvance.club',
        'webalan.ru',
        'webcamdevochka.com',
        'webenlace.com.ar',
        'webextract.profound.net',
        'webinstantservice.com',
        'webix.biz',
        'webix.me',
        'webjam.com',
        'webkeyit.com',
        'weblo.com',
        'webmasterhome.cn',
        'webmasters.stackexchange.com',
        'webmonetizer.net',
        'webnode.me',
        'weboptimizes.com',
        'webpromotion.ae',
        'webradiology.ru',
        'webs.com',
        'webscouter.net',
        'webshoppermac.com',
        'website-analytics.online',
        'website-analyzer.info',
        'website-audit.com.ua',
        'website-datenbank.de',
        'website-speed-check.site',
        'website-speed-checker.site',
        'website-speed-up.site',
        'website-speed-up.top',
        'website-stealer.nufaq.com',
        'websiteaccountant.de',
        'websiteexplorer.info',
        'websites-reviews.com',
        'websitevaluebot.com',
        'webstatsdomain.org',
        'webtherapy.ru',
        'weburlopener.com',
        'weburok.com',
        'wechatdownload10.com',
        'weclipart.com',
        'wedding-salon.net',
        'wedding0venues.tk',
        'weddingdresses.xyz',
        'weekes.biz.tc',
        'weightatraining.com',
        'wejdz-tu.pl',
        'welck.octopis.com',
        'welcomeauto.ru',
        'wellcome2slovenia.ru',
        'wemarketing.se',
        'wemedinc.com',
        'weprik.ru',
        'wesharepics.com',
        'wesharepics.info',
        'wesharepics.site',
        'westen-v.life',
        'westen-z.life',
        'westermarkanjou.se',
        'westsextube.com',
        'westum.se',
        'westvilletowingservices.co.za',
        'wetgames.ru',
        'wfb.hatedriveapart.com',
        'whatistizanidine2mg.blogspot.com',
        'whatistizanidinehclusedfor.blogspot.com',
        'whatsappdownload10.com',
        'whatsupinfoley.com',
        'whatzmyip.net',
        'wheelchairliftsarea.com',
        'whengirlsgowild.com',
        'where-toget.com',
        'whereiskentoday.com',
        'whereverdesperate.gq',
        'while.cheapwebsitehoster.com',
        'whipme.yopoint.in',
        'white-truck.life',
        'whiteelephantwellington.com',
        'whiteproduct.com',
        'wholesalecheapjerseysfree.com',
        'wholesalejerseychinaoutlet.com',
        'wholesalejerseychinashop.com',
        'wholesalejerseys-cheapest.com',
        'wholesalejerseyscheapjerseys.us.com',
        'wholesalejerseysgaa.com',
        'wholesalenfljerseys.us.com',
        'wholinkstome.com',
        'whos.amung.us',
        'whosonmyserver.com',
        'wieseversa.no',
        'wikes.20fr.com',
        'wildcattube.com',
        'wildnatureimages.com',
        'wildworld.site',
        'williamrobsonproperty.com',
        'win-spy.com',
        'windowssearch-exp.com',
        'wineitudes.wordpress.com',
        'wineration.com',
        'wingsoffury2.com',
        'wingsofrefuge.net',
        'winner7777.net',
        'winterclassichockeyjerseys.com',
        'winwotgold.pl',
        'winx-play.ru',
        'wiosenny-bon-1500.pl',
        'witherrom55.eklablog.fr',
        'withstandingheartwarming.com',
        'wjgony.com',
        'wladimirpayen.com',
        'wleuaprpxuvr.ga',
        'wma-x.com',
        'wnhjavlhezp.gq',
        'wnoz.de',
        'womama.ru',
        'woman-h.ru',
        'woman-orgasm.ru',
        'woman-tampon.ru',
        'womens-journal.net',
        'womensplay.net',
        'womensterritory.ru',
        'wonderfulflowers.biz',
        'woodyguthrie.se',
        'word-vorlagen.net',
        'word-vorlagen.xyz',
        'wordkeyhelper.com',
        'wordpress-crew.net',
        'wordpresscore.com',
        'workle.website',
        'works.if.ua',
        'world-mmo.com',
        'worldhistory.biz',
        'worldinternetauthority.com',
        'worldis.me',
        'worldlovers.ru',
        'worldmusicfests.com',
        'worldoffiles.ru',
        'worldtraveler.world',
        'wormix-cheats.ru',
        'wosik-dach.service-for-web.de',
        'wowas31.ucoz.ru',
        'woweb.com.ua',
        'wpsecurity.website',
        'wpthemedetector.co.uk',
        'writersgroup580.web.fc2.com',
        'writingservices17.blogspot.ru',
        'wrona.it',
        'ws.ampower.me',
        'wsgames.ru',
        'wstroika.ru',
        'wtsindia.in',
        'wttavern.com',
        'wufak.com',
        'wurr.voila.net',
        'ww1943.ru',
        'ww2awards.info',
        'www.888.com',
        'www.arenda-yeisk.ru',
        'www.event-tracking.com',
        'www.get-free-traffic-now.com',
        'www.kabbalah-red-bracelets.com',
        'www.timer4web.com',
        'wwwadultcheck.com',
        'wygraj-skiny.win',
        'wygraj-teraz.com',
        'wyniki-lista.pl',
        'wzgyyq.com',
        'x-diesel.biz',
        'x-diesel.com',
        'x-diesel.info',
        'x-diesel.org',
        'x-lime.net',
        'x-musics.com',
        'x-porno.video',
        'x-rates.ru',
        'x-stars.ru',
        'x-true.info',
        'x69ty.ru',
        'xaijo.com',
        'xaylapdiendanang.com',
        'xbaboon.com',
        'xblog.in',
        'xboxster.ru',
        'xcc24.pl',
        'xchangetrak.com',
        'xchat26.myfreecams.com',
        'xclicks.net',
        'xcombear.ru',
        'xdoza.com',
        'xedserver.com',
        'xep.info',
        'xerox-douglas.cf',
        'xev.ru',
        'xfire.com',
        'xfluro.com',
        'xgames-04.com',
        'xgftnlrt.bloger.index.hr',
        'xingzi-vision.com',
        'xitjw.info',
        'xjlottery.com',
        'xjrul.com',
        'xkaz.org',
        'xlolitka.com',
        'xlovecam.com',
        'xmladserver.com',
        'xmlinde.com',
        'xmronta.com',
        'xn------7cdbapdecfd4ak1bn0amjffj7afu3y.xn--p1ai',
        'xn-----6kcaacnblni5c5bicdpcmficy.xn--p1ai',
        'xn-----6kccaibs5cb8afhjrfmix2n.xn--p1ai',
        'xn-----7kcabaipgeakzcss7bjdqdwpfnhv.xn--p1ai',
        'xn-----7kceclhb4abre1b4a0ccl2fxch1a.xn--p1ai',
        'xn-----8kcatubaocd1bneepefojs1h2e.xn--p1ai',
        'xn----7sbaaabaei0cc8aj5bj0bncejx.xn--p1ai',
        'xn----7sbahjd3btneuw1joc.xn--p1ai',
        'xn----7sbaphztdjeboffeiof6c.xn--p1ai',
        'xn----7sbbagbq7bd5aheftfllo4m.xn--p1ai',
        'xn----7sbbahaq9bb5afgiqfliv4m.xn--p1ai',
        'xn----7sbho2agebbhlivy.xn--p1ai',
        'xn----7sbifcamovvfggw9d.xn--p1ai',
        'xn----8sbdbjgb1ap7a9c4czbh.xn--p1acf',
        'xn----8sbhefaln6acifdaon5c6f4axh.xn--p1ai',
        'xn----9sbebi2bvzr7h.xn--p1ai',
        'xn----9sbubg3ambdfl1j.xn--p1ai',
        'xn----dtbndd4ae7eub.top',
        'xn----itbeirbjbi7bc6bh2d.xn--p1ai',
        'xn----itbkqkfiq.xn--p1ai',
        'xn--1-8sbcpb0bdm8k6a.xn--p1ai',
        'xn--24-glceagatoq7c2a6ioc.xn--p1ai',
        'xn--80aaafbn2bc2ahdfrfkln6l.xn--p1ai',
        'xn--80aaagvmjabrs1aoc9luc.xn--p1ai',
        'xn--80aaajbdbddwj2alwjieei2afr3v.xn--p1ai',
        'xn--80aaaks3bbhabgbigamdr2h.xn--p1ai',
        'xn--80aafb2a.xn--p1ai',
        'xn--80aagddcgkbcqbad7amllnejg6dya.xn--p1ai',
        'xn--80aanaardaperhcem4a6i.com',
        'xn--80ab4aa2g.xn--p1ai',
        'xn--80abgj3a5acid6ghs.top',
        'xn--80adaggc5bdhlfamsfdij4p7b.xn--p1ai',
        'xn--80aeahghtf8ac5i.xn--p1ai',
        'xn--80aebbcbcdemfkhba4byaehoejh8dza3v.xn--p1ai',
        'xn--80ahdheogk5l.xn--p1ai',
        'xn--80ahvj9e.xn--p1ai',
        'xn--80aikhbrhr.net',
        'xn--80ajbshivpvn2i.xn--p1ai',
        'xn--80ajjbdhgmudixfjc8c5a9df8b.xn--p1ai',
        'xn--80ak6aa92e.com',
        'xn--80aodinpgi.xn--p1ai',
        'xn--90acenikpebbdd4f6d.xn--p1ai',
        'xn--b1adccaf1bzj.xn--p1ai',
        'xn--b1ag5cfn.xn--p1ai',
        'xn--b1agm2d.net',
        'xn--c1acygb.xn--p1ai',
        'xn--d1abj0abs9d.in.ua',
        'xn--d1aifoe0a9a.top',
        'xn--e1afanlbnfckd7c3d.xn--p1ai',
        'xn--e1aggki3c.xn--80adxhks',
        'xn--h1aakne2ba.xn--p1ai',
        'xn--h1ahbi.com.ua',
        'xn--hxazdsfy.blogspot.com',
        'xn--l1aengat.xn--p1ai',
        'xn--lifehacer-1rb.com',
        'xn--oogle-wmc.com',
        'xn--q1a.xn--b1aube0e.xn--c1acygb.xn--p1ai',
        'xnxx-n.com',
        'xnxxandxvideos.com',
        'xolodremont.ru',
        'xportvusbdriver8i.snack.ws',
        'xpresscare.ru',
        'xrus.org',
        'xsion.net',
        'xtrafficplus.com',
        'xtremeeagles.net',
        'xtube.com',
        'xtubeporno.net',
        'xuki.us',
        'xvideosbay.com',
        'xvideosporn.biz',
        'xwatt.ru',
        'xxart.ru',
        'xxlargepop.com',
        'xxx-cam.webcam',
        'xxx-treker.ru',
        'xxxdatinglocal.us',
        'xxxguitars.com',
        'xxxkaz.org',
        'xxxnatelefon.ru',
        'xxxrus.org',
        'xxxtube69.com',
        'xxxtubesafari.com',
        'xz618.com',
        'xzlive.com',
        'y8games-free.com',
        'yaaknaa.info',
        'yachts-cruise.info',
        'yaderenergy.ru',
        'yadro.ru',
        'yaminecraft.ru',
        'yaoguangdj.com',
        'yatrk.xyz',
        'yeartwit.com',
        'yebocasino.co.za',
        'yebocasino.com',
        'yellocloud.be',
        'yellowads.men',
        'yellowfootprints.com',
        'yellowstonesafaritours.com',
        'yellowstonevisitortours.com',
        'yes-com.com',
        'yhit.press',
        'ynymnwbm.bloger.index.hr',
        'yogamatsexpert.com',
        'yoluxuryevents.com',
        'yoopsie.com',
        'yopoint.in',
        'yorkshire.com',
        'yorkshireccc.com',
        'yoshkarola.zrus.org',
        'yottos.com',
        'you-shall-not-pass.is74.ru',
        'youandcredit.ru',
        'youbloodyripper.com',
        'youbrainboost.asia',
        'youdao.com',
        'youdesigner.kz',
        'yougame.biz',
        'yougetsignal.com',
        'youghbould.wordpress.com',
        'yougotanewdomain.com',
        'youjizz.com',
        'youjizz.vc',
        'youporn-forum.ga',
        'youporn-ru.com',
        'your-bearings.com',
        'youradexchange.com',
        'yourads.website',
        'youradulthosting.com',
        'youraticles.pl',
        'yourdesires.ru',
        'youresponsive.com',
        'yourmovies.pl',
        'yourothersite.com',
        'yourporn.com',
        'yourporngay.com',
        'yoursearch.me',
        'yourserverisdown.com',
        'yoursite.com',
        'yourtemplatefinder.com',
        'youthreaders.com',
        'youtoner.it',
        'youtube-downloader.savetubevideo.com',
        'youtubedownload.org',
        'youtuhe.com',
        'ypmuseum.ru',
        'ytmnd.com',
        'yuarra.pluto.ro',
        'yubikk.info',
        'yugk.net',
        'yugo-star.ru',
        'yun56.co',
        'yunque.pluto.ro',
        'yur-p.ru',
        'yurgorod.ru',
        'z-master.ru',
        'za-fun-offer.com',
        'za-music.mymobiplanet.com',
        'zaapplesales.blogspot.com',
        'zacreditom.ru',
        'zahvat.ru',
        'zaidia.xhost.ro',
        'zaim-pod-zalog-krasnodar.ru',
        'zaimhelp.ru',
        'zaimite.ru',
        'zajm-pod-zalog-nedvizhimosti.ru',
        'zajm-zalog-krasnodar.ru',
        'zakazfutbolki.com',
        'zakazvzloma.com',
        'zakon-ob-obrazovanii.ru',
        'zakonobosago.ru',
        'zaloadi.ru',
        'zaloro.com',
        'zambini.ru',
        'zaobao.com.sg',
        'zapiszto.pl',
        'zarabiaj-dzis.pl',
        'zarabotat-na-sajte.ru',
        'zarabotok--doma.ru',
        'zarajbuilders.com',
        'zarenica.net',
        'zarepta.com',
        'zastenchivosti.net',
        'zastroyka.org',
        'zatjmuzu.info',
        'zawyna.ua',
        'zazagames.org',
        'zdesformula.ru',
        'zdesoboi.com',
        'zebradudka.com',
        'zebramart.ru',
        'zed21.net',
        'zeg-distribution.com',
        'zeikopay.com',
        'zeleznobeton.ru',
        'zero1.it',
        'zerocash.msk.ru',
        'zeroredirect.com',
        'zeroredirect1.com',
        'zeroredirect10.com',
        'zeroredirect11.com',
        'zeroredirect12.com',
        'zeroredirect2.com',
        'zeroredirect5.com',
        'zeroredirect6.com',
        'zeroredirect7.com',
        'zeroredirect8.com',
        'zeroredirect9.com',
        'zetgie.com.pl',
        'zetmaster.ru',
        'zhacker.net',
        'zhongwenlink.com',
        'zhorapankratov7.blogspot.com',
        'zhuravlev.info',
        'zigarettenonl.canalblog.com',
        'zigarettenonlinekaufen.tumblr.com',
        'zigarettenonlinekaufen1.bloog.pl',
        'zigarettenonlinekaufen1.blox.pl',
        'zigarettenonlinekaufen2.bloog.pl',
        'zigarettenonlinekaufen2.drupalgardens.com',
        'zigzog.ru',
        'zionstar.net',
        'zixizop.net.ru',
        'zkjovpdgxivg.ga',
        'zlatnajesen.com',
        'zmoda.hostreo.com',
        'znakom.sibtest.ru',
        'znakomstva-moskva77.ru',
        'znakomstva-piter78.ru',
        'znakomstvaonlain.ru',
        'znaniyapolza.ru',
        'znaturaloriginal.com',
        'zocaparj.kz',
        'zog.link',
        'zojirushi-products.ru',
        'zolotoy-lis.ru',
        'zona-aqua.ru',
        'zone-kev717.info',
        'zoodrawings.com',
        'zoogdiesney.com',
        'zoogdinsney.com',
        'zoogdisany.com',
        'zooggames.com',
        'zoolubimets.ru',
        'zoominfo.com',
        'zoomovies.org',
        'zoompegs.com',
        'zoosexart.com',
        'zootoplist.com',
        'zootravel.com',
        'zophim.me',
        'zrelaya.pw',
        'zrizvtrnpale.tk',
        'zrus.org',
        'zryydi.com',
        'zs2vm.top',
        'zscaler.net',
        'zscalerone.net',
        'zscalertwo.net',
        'zverokruh-shop.cz',
        'zvetki.ru',
        'zvezdagedon.ru',
        'zx6.ru',
        'zynax.ua',
        'zytpirwai.net',
        'zzbroya.com.ua',
        'zzlgxh.com',
    );
}
